/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.helper;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobAccessPolicy;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public final class AzureUtils {
    private static final String TEST_CNT_NAME = "testcheckfromjenkins";
    private static final String BLOB = "blob";
    private static final String QUEUE = "queue";
    private static final String TABLE = "table";
    private static final int ONE_WEEK = 7;

    public static boolean validateStorageAccount(StorageAccountInfo storageAccount, boolean allowRetry) throws WAStorageException {
        try {
            BlobContainerClient container = AzureUtils.getBlobContainerReference(storageAccount, TEST_CNT_NAME, false, allowRetry, null);
            container.exists();
            if (!StringUtils.isBlank((CharSequence)storageAccount.getCdnEndPointURL())) {
                URL cdnEndpointURL = new URL(storageAccount.getCdnEndPointURL());
                HttpURLConnection huc = (HttpURLConnection)cdnEndpointURL.openConnection();
                huc.setRequestMethod("HEAD");
                huc.getResponseCode();
            }
        }
        catch (Exception e) {
            throw new WAStorageException(Messages.Client_SA_val_fail(), e);
        }
        return true;
    }

    public static BlobServiceClient getCloudStorageAccount(StorageAccountInfo storageAccount) {
        return AzureUtils.getCloudStorageAccount(storageAccount, new RequestRetryOptions());
    }

    public static ShareServiceClient getShareClient(StorageAccountInfo storageAccount) throws MalformedURLException, URISyntaxException {
        return new ShareServiceClientBuilder().credential(new StorageSharedKeyCredential(storageAccount.getStorageAccName(), storageAccount.getStorageAccountKey())).httpClient(HttpClientRetriever.get()).endpoint(storageAccount.getBlobEndPointURL().replace(BLOB, "file")).buildClient();
    }

    public static BlobServiceClient getCloudStorageAccount(StorageAccountInfo storageAccount, RequestRetryOptions retryOptions) {
        return new BlobServiceClientBuilder().credential(new StorageSharedKeyCredential(storageAccount.getStorageAccName(), storageAccount.getStorageAccountKey())).httpClient(HttpClientRetriever.get()).endpoint(storageAccount.getBlobEndPointURL()).retryOptions(retryOptions).buildClient();
    }

    public static BlobContainerClient getBlobContainerReference(StorageAccountInfo storageAccount, String containerName, boolean createIfNotExist, boolean allowRetry, Boolean cntPubAccess) throws URISyntaxException, IOException {
        RequestRetryOptions retryOptions = new RequestRetryOptions();
        if (!allowRetry) {
            retryOptions = new RequestRetryOptions(RetryPolicyType.FIXED, Integer.valueOf(1), Duration.ofSeconds(Integer.MAX_VALUE), Duration.ofMillis(1L), Duration.ofSeconds(1L), null);
        }
        BlobServiceClient cloudStorageAccount = AzureUtils.getCloudStorageAccount(storageAccount, retryOptions);
        BlobContainerClient containerClient = cloudStorageAccount.getBlobContainerClient(containerName);
        boolean cntExists = containerClient.exists();
        if (createIfNotExist && !cntExists) {
            containerClient.create();
        }
        AzureUtils.setContainerPermission(containerClient, cntExists, cntPubAccess);
        return containerClient;
    }

    public static String generateBlobSASURL(StorageAccountInfo storageAccount, String containerName, String blobName, BlobSasPermission permissions) {
        BlobServiceClient cloudStorageAccount = AzureUtils.getCloudStorageAccount(storageAccount);
        BlobContainerClient container = cloudStorageAccount.getBlobContainerClient(containerName);
        if (!container.exists()) {
            throw new IllegalStateException("WAStorageClient: generateBlobSASURL: Container " + containerName + " does not exist in storage account " + storageAccount.getStorageAccName());
        }
        BlobClient blob = container.getBlobClient(blobName);
        BlobServiceSasSignatureValues sasSignatureValues = new BlobServiceSasSignatureValues(AzureUtils.generateExpiryDate(), permissions);
        return blob.generateSas(sasSignatureValues);
    }

    public static String generateFileSASURL(StorageAccountInfo storageAccount, String shareName, String fileName, ShareFileSasPermission permissions) throws MalformedURLException, URISyntaxException {
        ShareServiceClient shareServiceClient = AzureUtils.getShareClient(storageAccount);
        ShareClient fileShare = shareServiceClient.getShareClient(shareName);
        if (!fileShare.exists().booleanValue()) {
            throw new IllegalStateException("WAStorageClient: generateFileSASURL: Share " + shareName + " does not exist in storage account " + storageAccount.getStorageAccName());
        }
        ShareFileClient cloudFile = fileShare.getRootDirectoryClient().getFileClient(fileName);
        ShareServiceSasSignatureValues sasSignatureValues = new ShareServiceSasSignatureValues(AzureUtils.generateExpiryDate(), permissions);
        return cloudFile.generateSas(sasSignatureValues);
    }

    private static OffsetDateTime generateExpiryDate() {
        return OffsetDateTime.now().plusHours(1L);
    }

    private static void setContainerPermission(BlobContainerClient container, boolean cntExists, Boolean cntPubAccess) {
        if (!cntExists && cntPubAccess != null && cntPubAccess.booleanValue()) {
            BlobSignedIdentifier identifier = new BlobSignedIdentifier().setId("name").setAccessPolicy(new BlobAccessPolicy().setStartsOn(OffsetDateTime.now()).setExpiresOn(OffsetDateTime.now().plusDays(7L)).setPermissions("r"));
            container.setAccessPolicy(PublicAccessType.CONTAINER, Collections.singletonList(identifier));
        }
    }

    private static String getEndpointSuffix(String blobURL) throws URISyntaxException {
        int endSuffixStartIndex = blobURL.toLowerCase().indexOf("core");
        if (endSuffixStartIndex < 0) {
            throw new URISyntaxException(blobURL, "The blob endpoint is not correct!");
        }
        return blobURL.substring(endSuffixStartIndex);
    }

    private AzureUtils() {
    }
}

