/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.service.UploadService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.PartialBlobProperties;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadServiceData;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadType;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.util.DirScanner;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public class UploadToBlobService
extends UploadService {
    public UploadToBlobService(UploadServiceData serviceData) {
        super(serviceData);
    }

    @Override
    protected void uploadArchive(String archiveIncludes) throws WAStorageException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        try {
            BlobContainerClient container = this.getCloudBlobContainer();
            if (serviceData.getUploadType() == UploadType.ZIP) {
                this.cleanupContainer(container);
            }
            FilePath workspacePath = serviceData.getRemoteWorkspace();
            FilePath tempDir = workspacePath.createTempDir("artifactsArchive", null);
            FilePath zipPath = tempDir.child("archive.zip");
            DirScanner.Glob globScanner = new DirScanner.Glob(archiveIncludes, this.excludedFilesAndZip());
            workspacePath.zip(zipPath.write(), (DirScanner)globScanner);
            Object blobURI = zipPath.getName();
            if (!StringUtils.isBlank((CharSequence)serviceData.getVirtualPath())) {
                blobURI = serviceData.getVirtualPath() + (String)blobURI;
            }
            BlockBlobClient blob = container.getBlobClient((String)blobURI).getBlockBlobClient();
            ArrayList<UploadService.UploadObject> uploadObjects = new ArrayList<UploadService.UploadObject>();
            PartialBlobProperties blobProperties = new PartialBlobProperties("UTF-8", null, null, null);
            UploadService.UploadObject uploadObject = this.generateUploadObject(zipPath, serviceData.getStorageAccountInfo(), blob, container.getBlobContainerName(), blobProperties, this.updateMetadata(new HashMap<String, String>()));
            uploadObjects.add(uploadObject);
            UploadService.UploadOnSlave uploadOnSlave = new UploadService.UploadOnSlave(Jenkins.get().proxy, uploadObjects);
            List results = (List)workspacePath.act((FilePath.FileCallable)uploadOnSlave);
            this.updateAzureBlobs(results, serviceData.getArchiveBlobs());
            tempDir.deleteRecursive();
        }
        catch (Exception e) {
            throw new WAStorageException("Fail to upload archive to blob", e);
        }
    }

    private UploadService.UploadObject generateUploadObject(FilePath path, StorageAccountInfo accountInfo, BlockBlobClient blob, String containerName, PartialBlobProperties blobProperties, Map<String, String> metadata) throws Exception {
        String sas = this.generateWriteSASURL(accountInfo, blob.getBlobName(), "blobstorage", containerName);
        return new UploadService.UploadObject(blob.getBlobName(), path, blob.getBlobUrl(), sas, "blobstorage", blob.getAccountName(), blobProperties, metadata);
    }

    @Override
    protected void uploadIndividuals(String embeddedVP, FilePath[] paths, FilePath workspace) throws WAStorageException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        try {
            BlobContainerClient container = this.getCloudBlobContainer();
            UploadType uploadType = serviceData.getUploadType();
            if (uploadType == UploadType.INDIVIDUAL || uploadType == UploadType.BOTH) {
                this.cleanupContainer(container);
            }
            ArrayList<UploadService.UploadObject> uploadObjects = new ArrayList<UploadService.UploadObject>();
            for (FilePath src : paths) {
                String blobPath = this.getItemPath(src, embeddedVP, serviceData);
                BlockBlobClient blob = container.getBlobClient(blobPath).getBlockBlobClient();
                PartialBlobProperties blobProperties = this.configureBlobProperties(src);
                UploadService.UploadObject uploadObject = this.generateUploadObject(src, serviceData.getStorageAccountInfo(), blob, container.getBlobContainerName(), blobProperties, this.updateMetadata(new HashMap<String, String>()));
                uploadObjects.add(uploadObject);
            }
            UploadService.UploadOnSlave uploadOnSlave = new UploadService.UploadOnSlave(Jenkins.get().proxy, uploadObjects);
            List results = (List)workspace.act((FilePath.FileCallable)uploadOnSlave);
            this.updateAzureBlobs(results, serviceData.getIndividualBlobs());
        }
        catch (Exception e) {
            throw new WAStorageException("Fail to upload individual files to blob", e);
        }
    }

    @Override
    @Deprecated
    protected void uploadIndividuals(String embeddedVP, FilePath[] paths) throws WAStorageException {
        throw new NotImplementedException();
    }

    private PartialBlobProperties configureBlobProperties(FilePath src) throws IOException, InterruptedException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        EnvVars env = serviceData.getRun().getEnvironment(serviceData.getTaskListener());
        if (serviceData.getBlobProperties() != null) {
            return serviceData.getBlobProperties().configure(src, env);
        }
        return new PartialBlobProperties("UTF-8", null, null, null);
    }

    private BlobContainerClient getCloudBlobContainer() throws URISyntaxException, IOException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        BlobContainerClient container = AzureUtils.getBlobContainerReference(serviceData.getStorageAccountInfo(), serviceData.getContainerName(), true, true, serviceData.isPubAccessible());
        return container;
    }

    private void cleanupContainer(BlobContainerClient container) throws IOException, URISyntaxException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        if (serviceData.isCleanUpContainerOrShare()) {
            this.println("Clean up existing blobs in container " + serviceData.getContainerName());
            this.deleteBlobs(container, (PagedIterable<BlobItem>)container.listBlobs());
        } else if (serviceData.isCleanUpVirtualPath() && StringUtils.isNotBlank((CharSequence)serviceData.getVirtualPath())) {
            this.println("Clean up existing blobs in container path " + serviceData.getVirtualPath());
            this.deleteBlobs(container, (PagedIterable<BlobItem>)container.listBlobsByHierarchy(serviceData.getVirtualPath()));
        }
    }

    private void deleteBlobs(BlobContainerClient container, PagedIterable<BlobItem> blobItems) {
        for (BlobItem blobItem : blobItems) {
            container.getBlobClient(blobItem.getName()).delete();
        }
    }
}

