/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.helper;

import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AzureCredentialsBinding
extends MultiBinding<AzureStorageAccount> {
    public static final String DEFAULT_STORAGE_ACCOUNT_NAME = "AZURE_STORAGE_ACCOUNT_NAME";
    public static final String DEFAULT_STORAGE_ACCOUNT_KEY = "AZURE_STORAGE_ACCOUNT_KEY";
    public static final String DEFAULT_BLOB_ENDPOINT_URL = "AZURE_BLOB_ENDPOINT_URL";
    public static final String DEFAULT_CDN_ENDPOINT_URL = "AZURE_CDN_ENDPOINT_URL";
    private String storageAccountNameVariable;
    private String storageAccountKeyVariable;
    private String blobEndpointUrlVariable;
    private String cdnEndpointUrlVariable;

    @DataBoundConstructor
    public AzureCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    @DataBoundSetter
    public void setStorageAccountNameVariable(String storageAccountNameVariable) {
        this.storageAccountNameVariable = storageAccountNameVariable;
    }

    @DataBoundSetter
    public void setStorageAccountKeyVariable(String storageAccountKeyVariable) {
        this.storageAccountKeyVariable = storageAccountKeyVariable;
    }

    @DataBoundSetter
    public void setBlobEndpointUrlVariable(String blobEndpointUrlVariable) {
        this.blobEndpointUrlVariable = blobEndpointUrlVariable;
    }

    @DataBoundSetter
    public void setCdnEndpointUrlVariable(String cdnEndpointUrlVariable) {
        this.cdnEndpointUrlVariable = cdnEndpointUrlVariable;
    }

    public String getStorageAccountNameVariable() {
        if (!StringUtils.isBlank((CharSequence)this.storageAccountNameVariable)) {
            return this.storageAccountNameVariable;
        }
        return DEFAULT_STORAGE_ACCOUNT_NAME;
    }

    public String getStorageAccountKeyVariable() {
        if (!StringUtils.isBlank((CharSequence)this.storageAccountKeyVariable)) {
            return this.storageAccountKeyVariable;
        }
        return DEFAULT_STORAGE_ACCOUNT_KEY;
    }

    public String getBlobEndpointUrlVariable() {
        if (!StringUtils.isBlank((CharSequence)this.blobEndpointUrlVariable)) {
            return this.blobEndpointUrlVariable;
        }
        return DEFAULT_BLOB_ENDPOINT_URL;
    }

    public String getCdnEndpointUrlVariable() {
        if (!StringUtils.isBlank((CharSequence)this.cdnEndpointUrlVariable)) {
            return this.cdnEndpointUrlVariable;
        }
        return DEFAULT_CDN_ENDPOINT_URL;
    }

    protected Class<AzureStorageAccount> type() {
        return AzureStorageAccount.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException {
        AzureStorageAccount credentials = (AzureStorageAccount)this.getCredentials(build);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put(this.getStorageAccountNameVariable(), credentials.getStorageAccountName());
        variableMap.put(this.getStorageAccountKeyVariable(), credentials.getPlainStorageKey());
        variableMap.put(this.getBlobEndpointUrlVariable(), credentials.getBlobEndpointURL());
        if (credentials.getCdnEndpointURL() != null) {
            variableMap.put(this.getCdnEndpointUrlVariable(), credentials.getCdnEndpointURL());
        }
        return new MultiBinding.MultiEnvironment(variableMap);
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.getStorageAccountNameVariable(), this.getStorageAccountKeyVariable(), this.getBlobEndpointUrlVariable()));
    }

    @Symbol(value={"azureStorage"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<AzureStorageAccount> {
        protected Class<AzureStorageAccount> type() {
            return AzureStorageAccount.class;
        }

        public boolean requiresWorkspace() {
            return false;
        }

        public String getDisplayName() {
            return Messages.AzureStorage_credentials_binding_display_name();
        }

        public static String getDefaultStorageAccountNameVariable() {
            return AzureCredentialsBinding.DEFAULT_STORAGE_ACCOUNT_NAME;
        }

        public static String getDefaultStorageAccountKeyVariable() {
            return AzureCredentialsBinding.DEFAULT_STORAGE_ACCOUNT_KEY;
        }

        public static String getDefaultBlobEndpointUrlVariable() {
            return AzureCredentialsBinding.DEFAULT_BLOB_ENDPOINT_URL;
        }

        public static String getDefaultCdnEndpointUrlVariable() {
            return AzureCredentialsBinding.DEFAULT_CDN_ENDPOINT_URL;
        }
    }
}

