/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlob;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobAction;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobMetadataPair;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobProjectAction;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobProperties;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.helper.Constants;
import com.microsoftopentechnologies.windowsazurestorage.helper.CredentialMigration;
import com.microsoftopentechnologies.windowsazurestorage.helper.CredentialRename;
import com.microsoftopentechnologies.windowsazurestorage.helper.Utils;
import com.microsoftopentechnologies.windowsazurestorage.service.UploadService;
import com.microsoftopentechnologies.windowsazurestorage.service.UploadToBlobService;
import com.microsoftopentechnologies.windowsazurestorage.service.UploadToFileService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadServiceData;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadType;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class WAStoragePublisher
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(WAStoragePublisher.class.getName());
    private final String storageType;
    private String containerName;
    private String fileShareName;
    private AzureBlobProperties blobProperties;
    private List<AzureBlobMetadataPair> metadata;
    private boolean pubAccessible;
    private boolean cleanUpContainerOrShare;
    private boolean cleanUpVirtualPath;
    private boolean allowAnonymousAccess;
    private boolean uploadArtifactsOnlyIfSuccessful;
    private boolean doNotFailIfArchivingReturnsNothing;
    private boolean uploadZips;
    private boolean doNotUploadIndividualFiles;
    private final String filesPath;
    private String excludeFilesPath = "";
    private String virtualPath = "";
    private String removePrefixPath = "";
    private boolean doNotWaitForPreviousBuild;
    private final String storageCredentialId;
    private boolean onlyUploadModifiedArtifacts;
    private boolean verbose;
    private transient AzureStorageAccount.StorageAccountCredential storageCreds;

    @DataBoundConstructor
    public WAStoragePublisher(String storageCredentialId, String filesPath, String storageType) {
        this.filesPath = filesPath.trim();
        this.storageType = storageType;
        this.storageCredentialId = storageCredentialId;
    }

    @DataBoundSetter
    public void setContainerName(String containerName) {
        this.containerName = Util.fixEmpty((String)containerName);
    }

    @DataBoundSetter
    public void setFileShareName(String fileShareName) {
        this.fileShareName = Util.fixEmpty((String)fileShareName);
    }

    @DataBoundSetter
    public void setBlobProperties(AzureBlobProperties blobProperties) {
        this.blobProperties = blobProperties;
    }

    @DataBoundSetter
    public void setPubAccessible(boolean pubAccessible) {
        this.pubAccessible = pubAccessible;
    }

    @DataBoundSetter
    public void setCleanUpContainerOrShare(boolean cleanUpContainerOrShare) {
        this.cleanUpContainerOrShare = cleanUpContainerOrShare;
    }

    @DataBoundSetter
    public void setCleanUpVirtualPath(boolean cleanUpVirtualPath) {
        this.cleanUpVirtualPath = cleanUpVirtualPath;
    }

    @DataBoundSetter
    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    @DataBoundSetter
    public void setUploadArtifactsOnlyIfSuccessful(boolean uploadArtifactsOnlyIfSuccessful) {
        this.uploadArtifactsOnlyIfSuccessful = uploadArtifactsOnlyIfSuccessful;
    }

    @DataBoundSetter
    public void setDoNotFailIfArchivingReturnsNothing(boolean doNotFailIfArchivingReturnsNothing) {
        this.doNotFailIfArchivingReturnsNothing = doNotFailIfArchivingReturnsNothing;
    }

    @DataBoundSetter
    public void setUploadZips(boolean uploadZips) {
        this.uploadZips = uploadZips;
    }

    @DataBoundSetter
    public void setDoNotUploadIndividualFiles(boolean doNotUploadIndividualFiles) {
        this.doNotUploadIndividualFiles = doNotUploadIndividualFiles;
    }

    @DataBoundSetter
    public void setExcludeFilesPath(String excludeFilesPath) {
        this.excludeFilesPath = excludeFilesPath;
    }

    @DataBoundSetter
    public void setVirtualPath(String virtualPath) {
        this.virtualPath = virtualPath;
    }

    public String getRemovePrefixPath() {
        return this.removePrefixPath;
    }

    @DataBoundSetter
    public void setRemovePrefixPath(String removePrefixPath) {
        this.removePrefixPath = removePrefixPath;
    }

    @DataBoundSetter
    public void setDoNotWaitForPreviousBuild(boolean doNotWaitForPreviousBuild) {
        this.doNotWaitForPreviousBuild = doNotWaitForPreviousBuild;
    }

    @DataBoundSetter
    public void setOnlyUploadModifiedArtifacts(boolean onlyUploadModifiedArtifacts) {
        this.onlyUploadModifiedArtifacts = onlyUploadModifiedArtifacts;
    }

    @DataBoundSetter
    public void setMetadata(List<AzureBlobMetadataPair> metadata) {
        this.metadata = metadata;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @DataBoundSetter
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getFilesPath() {
        return this.filesPath;
    }

    public String getExcludeFilesPath() {
        return this.excludeFilesPath;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getFileShareName() {
        return this.fileShareName;
    }

    public String getStorageType() {
        if (Constants.isValidStorageType(this.storageType)) {
            return this.storageType;
        }
        return "blobstorage";
    }

    public AzureBlobProperties getBlobProperties() {
        return this.blobProperties;
    }

    public List<AzureBlobMetadataPair> getMetadata() {
        return this.metadata;
    }

    public boolean isPubAccessible() {
        return this.pubAccessible;
    }

    public boolean isCleanUpContainerOrShare() {
        return this.cleanUpContainerOrShare;
    }

    public boolean isCleanUpVirtualPath() {
        return this.cleanUpVirtualPath;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public boolean isDoNotFailIfArchivingReturnsNothing() {
        return this.doNotFailIfArchivingReturnsNothing;
    }

    public boolean isUploadArtifactsOnlyIfSuccessful() {
        return this.uploadArtifactsOnlyIfSuccessful;
    }

    public boolean isUploadZips() {
        return this.uploadZips;
    }

    public boolean isDoNotUploadIndividualFiles() {
        return this.doNotUploadIndividualFiles;
    }

    public boolean isDoNotWaitForPreviousBuild() {
        return this.doNotWaitForPreviousBuild;
    }

    public boolean isOnlyUploadModifiedArtifacts() {
        return this.onlyUploadModifiedArtifacts;
    }

    public String getStorageCredentialId() {
        return this.storageCredentialId;
    }

    private UploadType computeArtifactUploadType(boolean zips, boolean doNotUploadIndividual) {
        if (zips && !doNotUploadIndividual) {
            return UploadType.BOTH;
        }
        if (!doNotUploadIndividual) {
            return UploadType.INDIVIDUAL;
        }
        if (zips) {
            return UploadType.ZIP;
        }
        return UploadType.INVALID;
    }

    public UploadType getArtifactUploadType() {
        return this.computeArtifactUploadType(this.uploadZips, this.doNotUploadIndividualFiles);
    }

    @Deprecated
    public String getStorageAccName() {
        return this.getStorageAccName(null);
    }

    public String getStorageAccName(Item owner) {
        AzureStorageAccount.StorageAccountCredential credential = this.getStorageAccountCredentials(owner);
        if (credential != null) {
            return credential.getStorageAccountName();
        }
        return null;
    }

    public AzureStorageAccount.StorageAccountCredential getStorageAccountCredentials(Item owner) {
        if (this.storageCreds == null) {
            this.storageCreds = AzureStorageAccount.getStorageAccountCredential(owner, this.getStorageCredentialId());
        }
        return this.storageCreds;
    }

    public String getVirtualPath() {
        return this.virtualPath;
    }

    public WAStorageDescriptor getDescriptor() {
        return (WAStorageDescriptor)super.getDescriptor();
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        AzureBlobProjectAction projectAction = new AzureBlobProjectAction(project);
        ArrayList<AzureBlobProjectAction> projectActions = new ArrayList<AzureBlobProjectAction>();
        projectActions.add(projectAction);
        return Collections.unmodifiableList(projectActions);
    }

    @Deprecated
    public StorageAccountInfo getStorageAccount() {
        String accountName = this.getStorageAccName();
        StorageAccountInfo storageAcc = null;
        for (StorageAccountInfo sa : this.getDescriptor().getStorageAccounts()) {
            if (!sa.getStorageAccName().equals(accountName)) continue;
            storageAcc = sa;
            storageAcc.setBlobEndPointURL(Utils.getBlobEP(storageAcc.getBlobEndPointURL()));
            break;
        }
        return storageAcc;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath ws, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        String expShareName;
        String expContainerName;
        EnvVars envVars = run.getEnvironment(listener);
        AzureStorageAccount.StorageAccountCredential credential = this.getStorageAccountCredentials((Item)run.getParent());
        if (credential == null) {
            throw new AbortException(String.format("Cannot find storage account credentials with ID: '%s'", this.getStorageCredentialId()));
        }
        StorageAccountInfo storageAccountInfo = AzureStorageAccount.convertToStorageAccountInfo(credential);
        if (!this.validateData(run, listener, storageAccountInfo, expContainerName = Utils.replaceMacro(Util.fixNull((String)this.containerName), (Map<String, String>)envVars, Locale.ENGLISH), expShareName = Utils.replaceMacro(Util.fixNull((String)this.fileShareName), (Map<String, String>)envVars, Locale.ENGLISH))) {
            throw new IOException("Plugin can not continue, until previous errors are addressed");
        }
        UploadServiceData serviceData = new UploadServiceData(run, ws, launcher, listener, storageAccountInfo);
        serviceData.setContainerName(expContainerName);
        serviceData.setFileShareName(expShareName);
        serviceData.setFilePath(Utils.replaceMacro(Util.fixNull((String)this.filesPath), (Map<String, String>)envVars));
        serviceData.setExcludedFilesPath(Utils.replaceMacro(Util.fixNull((String)this.excludeFilesPath), (Map<String, String>)envVars));
        serviceData.setBlobProperties(this.blobProperties == null ? new AzureBlobProperties() : this.blobProperties);
        serviceData.setPubAccessible(this.pubAccessible);
        serviceData.setCleanUpContainerOrShare(this.cleanUpContainerOrShare);
        serviceData.setCleanUpVirtualPath(this.cleanUpVirtualPath);
        serviceData.setUploadType(this.getArtifactUploadType());
        serviceData.setAzureBlobMetadata(this.metadata);
        serviceData.setOnlyUploadModifiedArtifacts(this.onlyUploadModifiedArtifacts);
        serviceData.setCredentialsId(this.getStorageCredentialId());
        serviceData.setVerbose(this.isVerbose());
        Object expVP = Utils.replaceMacro(Util.fixNull((String)this.virtualPath), (Map<String, String>)envVars);
        if (!StringUtils.isBlank((CharSequence)expVP) && !((String)expVP).endsWith("/")) {
            expVP = (String)expVP + "/";
        }
        serviceData.setVirtualPath((String)expVP);
        Object rmPrefixPath = Utils.replaceMacro(Util.fixNull((String)this.removePrefixPath), (Map<String, String>)envVars);
        if (!StringUtils.isBlank((CharSequence)rmPrefixPath) && !((String)rmPrefixPath).endsWith("/")) {
            rmPrefixPath = (String)rmPrefixPath + "/";
        }
        serviceData.setRemovePrefixPath((String)rmPrefixPath);
        UploadService service = this.getUploadService(serviceData);
        try {
            int filesCount = service.execute();
            if (filesCount == 0) {
                listener.getLogger().println(Messages.WAStoragePublisher_nofiles_uploaded());
                if (!this.doNotFailIfArchivingReturnsNothing) {
                    throw new IOException(Messages.WAStoragePublisher_nofiles_uploaded());
                }
            } else {
                AzureBlob zipArchiveBlob = null;
                if (this.getArtifactUploadType() != UploadType.INDIVIDUAL) {
                    zipArchiveBlob = serviceData.getArchiveBlobs().get(0);
                }
                List<AzureBlob> individualBlobs = serviceData.getIndividualBlobs();
                AzureBlobAction existAction = (AzureBlobAction)run.getAction(AzureBlobAction.class);
                if (existAction != null) {
                    List<AzureBlob> existActionIndividualBlobs = existAction.getIndividualBlobs();
                    existActionIndividualBlobs.addAll(individualBlobs);
                } else {
                    run.addAction((Action)new AzureBlobAction(individualBlobs, zipArchiveBlob, this.allowAnonymousAccess, this.getStorageCredentialId()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.error(Messages.WAStoragePublisher_uploaded_err(storageAccountInfo.getStorageAccName())));
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(Messages.WAStoragePublisher_uploaded_err(storageAccountInfo.getStorageAccName()), e);
        }
    }

    private boolean validateData(Run<?, ?> run, TaskListener listener, StorageAccountInfo storageAccount, String expContainerName, String expShareName) throws IOException, InterruptedException {
        if ((run.getResult() == Result.FAILURE || run.getResult() == Result.ABORTED) && this.uploadArtifactsOnlyIfSuccessful) {
            listener.getLogger().println(Messages.WAStoragePublisher_build_failed_err());
            return false;
        }
        if (storageAccount == null) {
            listener.getLogger().println(Messages.WAStoragePublisher_storage_account_err());
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.filesPath)) {
            listener.getLogger().println(Messages.WAStoragePublisher_filepath_err());
            return false;
        }
        if (this.getArtifactUploadType() == UploadType.INVALID) {
            listener.getLogger().println(Messages.WAStoragePublisher_uploadtype_invalid());
            return false;
        }
        if ("blobstorage".equalsIgnoreCase(this.getStorageType())) {
            if (StringUtils.isBlank((CharSequence)expContainerName)) {
                listener.getLogger().println("Container name is null or empty");
                return false;
            }
            if (!Utils.validateContainerName(expContainerName)) {
                listener.getLogger().println("Container name contains invalid characters");
                return false;
            }
        } else if ("filestorage".equalsIgnoreCase(this.getStorageType())) {
            if (StringUtils.isBlank((CharSequence)expShareName)) {
                listener.getLogger().println("Share name is null or empty");
                return false;
            }
            if (!Utils.validateFileShareName(expShareName)) {
                listener.getLogger().println("Share name contains invalid characters");
                return false;
            }
        } else {
            listener.getLogger().println("Invalid storage type.");
            return false;
        }
        try {
            AzureUtils.validateStorageAccount(storageAccount, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            listener.getLogger().println(Messages.Client_SA_val_fail());
            listener.getLogger().println("Storage Account name --->" + storageAccount.getStorageAccName() + "<----");
            listener.getLogger().println("Blob end point url --->" + storageAccount.getBlobEndPointURL() + "<----");
            return false;
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        if (this.doNotWaitForPreviousBuild) {
            return BuildStepMonitor.NONE;
        }
        return BuildStepMonitor.STEP;
    }

    private UploadService getUploadService(UploadServiceData data) {
        if ("filestorage".equalsIgnoreCase(this.getStorageType())) {
            return new UploadToFileService(data);
        }
        return new UploadToBlobService(data);
    }

    @Extension
    @Symbol(value={"azureUpload"})
    public static final class WAStorageDescriptor
    extends BuildStepDescriptor<Publisher> {
        private static final CopyOnWriteList<StorageAccountInfo> STORAGE_ACCOUNTS = new CopyOnWriteList();

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void doUpgrade() {
            try {
                CredentialMigration.upgradeStorageConfig();
                CredentialRename.renameStorageConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public WAStorageDescriptor() {
            this.load();
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            STORAGE_ACCOUNTS.replaceBy((Collection)req.bindParametersToList(StorageAccountInfo.class, "was_"));
            this.save();
            return super.configure(req, formData);
        }

        @POST
        public FormValidation doCheckAccount(@QueryParameter String was_storageAccName, @QueryParameter String was_storageAccountKey, @QueryParameter String was_blobEndPointURL, @QueryParameter String was_cdnEndPointURL) throws IOException, ServletException {
            if (StringUtils.isBlank((CharSequence)was_storageAccName)) {
                return FormValidation.error((String)Messages.WAStoragePublisher_storage_name_req());
            }
            if (StringUtils.isBlank((CharSequence)was_storageAccountKey)) {
                return FormValidation.error((String)Messages.WAStoragePublisher_storage_key_req());
            }
            String blobEndPointURL = was_blobEndPointURL;
            String cdnEndPointURL = was_cdnEndPointURL;
            try {
                blobEndPointURL = Utils.getBlobEP(blobEndPointURL);
                StorageAccountInfo storageAccount = new StorageAccountInfo(was_storageAccName, was_storageAccountKey, blobEndPointURL, cdnEndPointURL);
                AzureUtils.validateStorageAccount(storageAccount, false);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)("Error : " + e.getMessage()));
            }
            return FormValidation.ok((String)Messages.WAStoragePublisher_SA_val());
        }

        @POST
        public FormValidation doCheckContainerName(@QueryParameter(value="value") String containerName) {
            if (!StringUtils.isBlank((CharSequence)containerName)) {
                if (Utils.containTokens(containerName) || Utils.validateContainerName(containerName)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.WAStoragePublisher_container_name_invalid());
            }
            return FormValidation.error((String)Messages.WAStoragePublisher_container_name_req());
        }

        @POST
        public FormValidation doCheckFileShareName(@QueryParameter(value="value") String fileShareName) {
            if (!StringUtils.isBlank((CharSequence)fileShareName)) {
                if (Utils.containTokens(fileShareName) || Utils.validateFileShareName(fileShareName)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.WAStoragePublisher_share_name_invalid());
            }
            return FormValidation.error((String)Messages.WAStoragePublisher_share_name_req());
        }

        @POST
        public FormValidation doCheckFilesPath(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)Messages.WAStoragePublisher_artifacts_req());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckBlobName(@QueryParameter String val) {
            if (StringUtils.isBlank((CharSequence)val)) {
                return FormValidation.error((String)Messages.AzureStorageBuilder_blobName_req());
            }
            if (!Utils.validateBlobName(val)) {
                return FormValidation.error((String)Messages.AzureStorageBuilder_blobName_invalid());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.WAStoragePublisher_displayName();
        }

        public StorageAccountInfo[] getStorageAccounts() {
            return (StorageAccountInfo[])STORAGE_ACCOUNTS.toArray((Object[])new StorageAccountInfo[STORAGE_ACCOUNTS.size()]);
        }

        public StorageAccountInfo getStorageAccount(String name) {
            if (name == null || name.trim().length() == 0) {
                return null;
            }
            StorageAccountInfo storageAccountInfo = null;
            StorageAccountInfo[] storageAccountList = this.getStorageAccounts();
            if (storageAccountList != null) {
                for (StorageAccountInfo sa : storageAccountList) {
                    if (!sa.getStorageAccName().equals(name)) continue;
                    storageAccountInfo = sa;
                    storageAccountInfo.setBlobEndPointURL(Utils.getBlobEP(storageAccountInfo.getBlobEndPointURL()));
                    break;
                }
            }
            return storageAccountInfo;
        }

        public String getDefaultBlobURL() {
            return Utils.getDefaultBlobURL();
        }

        public ListBoxModel doFillStorageAccNameItems() {
            ListBoxModel m = new ListBoxModel();
            StorageAccountInfo[] storageAccounts = this.getStorageAccounts();
            if (storageAccounts != null) {
                for (StorageAccountInfo storageAccount : storageAccounts) {
                    m.add(storageAccount.getStorageAccName());
                }
            }
            return m;
        }

        public ListBoxModel doFillStorageCredentialIdItems(@AncestorInPath Item owner) {
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentialsInItem(AzureStorageAccount.class, (Item)owner, (Authentication)ACL.SYSTEM2, Collections.emptyList()));
        }

        @Restricted(value={NoExternalUse.class})
        public List<String> getStorageCredentials() {
            Object owner = null;
            List storageAccounts = CredentialsProvider.lookupCredentialsInItem(AzureStorageAccount.class, null, (Authentication)ACL.SYSTEM2);
            ArrayList<String> allStorageCred = new ArrayList<String>();
            for (AzureStorageAccount storageAccount : storageAccounts) {
                allStorageCred.add(String.format("%s (%s)", storageAccount.getStorageAccountName(), storageAccount.getId()));
            }
            return allStorageCred;
        }

        @Restricted(value={NoExternalUse.class})
        public String getAjaxURI() {
            return "/descriptor/com.cloudbees.plugins.credentials.CredentialsSelectHelper/resolver/com.cloudbees.plugins.credentials.CredentialsSelectHelper$SystemContextResolver/provider/com.cloudbees.plugins.credentials.SystemCredentialsProvider$ProviderImpl/context/jenkins/dialog";
        }
    }
}

