/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.file.share.ShareFileClient;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.service.StoragePluginService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.DownloadServiceData;
import hudson.FilePath;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.AntPathMatcher;

public abstract class DownloadService
extends StoragePluginService<DownloadServiceData> {
    protected static final String DOWNLOAD = "Download";
    protected static final String DOWNLOAD_FAILED = "DownloadFailed";
    private static final int DOWNLOAD_THREAD_COUNT = 16;
    private static final int KEEP_ALIVE_TIME = 1;
    private static final int TIME_OUT = 1;
    private static final TimeUnit TIME_OUT_UNIT = TimeUnit.DAYS;
    private AtomicInteger filesDownloaded = new AtomicInteger(0);
    private ExecutorService executorService = new ThreadPoolExecutor(16, 16, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());

    public DownloadService(DownloadServiceData data) {
        super(data);
    }

    protected void waitForDownloadEnd() throws WAStorageException {
        this.executorService.shutdown();
        try {
            boolean executionFinished = this.executorService.awaitTermination(1L, TIME_OUT_UNIT);
            if (!executionFinished) {
                throw new WAStorageException(Messages.AzureStorageBuilder_download_timeout(1, (Object)TIME_OUT_UNIT));
            }
        }
        catch (InterruptedException e) {
            throw new WAStorageException(e.getMessage(), e);
        }
    }

    protected void downloadSingleFile(ShareFileClient cloudFile) throws WAStorageException {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        try {
            if (serviceData.isVerbose()) {
                this.println("Downloading file:" + cloudFile.getFileUrl());
            }
            FilePath destFile = this.destinationFilePath(cloudFile.getFilePath());
            long startTime = System.currentTimeMillis();
            try (OutputStream fos = destFile.write();){
                cloudFile.download(fos);
            }
            long endTime = System.currentTimeMillis();
            this.println(String.format("blob %s is downloaded to %s in %s", cloudFile.getFilePath(), destFile.getParent(), this.getTime(endTime - startTime)));
            if (serviceData.isDeleteFromAzureAfterDownload()) {
                if (cloudFile.exists().booleanValue()) {
                    cloudFile.delete();
                }
                this.println("cloud file " + cloudFile.getFilePath() + " is deleted from Azure.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new WAStorageException(e.getMessage(), e);
        }
    }

    protected void downloadBlob(BlobClientBase blob) throws WAStorageException {
        try {
            if (((DownloadServiceData)this.getServiceData()).isVerbose()) {
                this.println("Downloading file:" + blob.getBlobUrl());
            }
            FilePath destFile = this.destinationFilePath(blob.getBlobName());
            long startTime = System.currentTimeMillis();
            try (OutputStream fos = destFile.write();){
                blob.download(fos);
            }
            long endTime = System.currentTimeMillis();
            this.println(String.format("blob %s is downloaded to %s in %s", blob.getBlobName(), destFile.getParent(), this.getTime(endTime - startTime)));
            if (((DownloadServiceData)this.getServiceData()).isDeleteFromAzureAfterDownload()) {
                if (blob.exists().booleanValue()) {
                    blob.delete();
                }
                this.println("blob " + blob.getBlobName() + " is deleted from Azure.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new WAStorageException(e.getMessage(), e);
        }
    }

    protected boolean shouldDownload(String includePattern, String excludePattern, String blobName, boolean isFullPath) {
        String[] includePatterns = includePattern.split(",");
        String[] excludePatterns = null;
        if (excludePattern != null) {
            excludePatterns = excludePattern.split(",");
        }
        return this.blobPathMatches(blobName, includePatterns, excludePatterns, isFullPath);
    }

    private FilePath destinationFilePath(String name) {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        FilePath downloadDir = serviceData.getDownloadDir();
        FilePath downloadFile = new FilePath(downloadDir, name);
        if (serviceData.isFlattenDirectories()) {
            downloadFile = new FilePath(downloadDir, downloadFile.getName());
        }
        return downloadFile;
    }

    private boolean blobPathMatches(String path, String[] includePatterns, String[] excludePatterns, boolean isFullPath) {
        if (!isFullPath) {
            return this.isPotentialMatch(path, includePatterns);
        }
        return this.isExactMatch(path, includePatterns) && (excludePatterns == null || !this.isExactMatch(path, excludePatterns));
    }

    private boolean isPotentialMatch(String path, String[] patterns) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : patterns) {
            if (!matcher.matchStart(pattern, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isExactMatch(String path, String[] patterns) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : patterns) {
            if (!matcher.match(pattern, path)) continue;
            return true;
        }
        return false;
    }

    public int getFilesDownloaded() {
        return this.filesDownloaded.get();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    class DownloadThread
    implements Runnable {
        private Object downloadItem;

        DownloadThread(Object downloadItem) {
            this.downloadItem = downloadItem;
        }

        @Override
        public void run() {
            try {
                if (this.downloadItem instanceof BlobClientBase) {
                    DownloadService.this.downloadBlob((BlobClientBase)this.downloadItem);
                } else {
                    DownloadService.this.downloadSingleFile((ShareFileClient)this.downloadItem);
                }
                DownloadService.this.filesDownloaded.addAndGet(1);
            }
            catch (Exception e) {
                String message = Messages.AzureStorageBuilder_download_err(((DownloadServiceData)DownloadService.this.getServiceData()).getStorageAccountInfo().getStorageAccName()) + ":" + e.getMessage();
                e.printStackTrace(DownloadService.this.error(message));
                DownloadService.this.println(message);
                DownloadService.this.setRunUnstable();
            }
        }
    }
}

