/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage;

import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlob;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Run;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

@ExportedBean
public class AzureBlobAction
implements RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(AzureBlobAction.class.getName());
    private transient Run<?, ?> build;
    private final boolean allowAnonymousAccess;
    private final AzureBlob zipArchiveBlob;
    private final List<AzureBlob> individualBlobs;
    private final String storageCredentialId;

    public AzureBlobAction(List<AzureBlob> individualBlobs, AzureBlob zipArchiveBlob, boolean allowAnonymousAccess, String storageCredentialId) {
        this.individualBlobs = individualBlobs;
        this.allowAnonymousAccess = allowAnonymousAccess;
        this.zipArchiveBlob = zipArchiveBlob;
        this.storageCredentialId = storageCredentialId;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getDisplayName() {
        return "Azure Artifacts";
    }

    public String getIconFileName() {
        return "/plugin/windows-azure-storage/images/24x24/Azure.png";
    }

    public String getUrlName() {
        return "Azure";
    }

    @Exported
    public AzureBlob getZipArchiveBlob() {
        return this.zipArchiveBlob;
    }

    public void onAttached(Run<?, ?> r) {
        this.build = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = r;
    }

    @Exported
    public List<AzureBlob> getIndividualBlobs() {
        return this.individualBlobs;
    }

    public boolean getAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void doProcessDownloadRequest(StaplerRequest2 request, StaplerResponse2 response) throws IOException, ServletException {
        if (!this.allowAnonymousAccess && this.isAnonymousAccess(Jenkins.getAuthentication2())) {
            String url = request.getOriginalRequestURI();
            response.sendRedirect(request.getContextPath() + "/login?from=" + url);
            return;
        }
        String queryPath = request.getRestOfPath();
        if (queryPath == null) {
            return;
        }
        String blobName = queryPath.substring(1);
        if (this.zipArchiveBlob != null && blobName.equals(URLDecoder.decode(this.zipArchiveBlob.getBlobName(), StandardCharsets.UTF_8.toString()))) {
            StorageAccountInfo accountInfo = this.getStorageAccountInfo(this.storageCredentialId);
            if (accountInfo == null) {
                response.sendError(500, "Azure Storage account global configuration is missing");
                return;
            }
            try {
                response.sendRedirect2(this.zipArchiveBlob.getBlobURL() + "?" + this.generateReadSASURL(accountInfo, this.zipArchiveBlob));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error downloading artifact", e);
                response.sendError(500, "Error occurred while downloading artifact " + e.getMessage());
            }
            return;
        }
        for (AzureBlob blob : this.individualBlobs) {
            if (!blobName.equals(URLDecoder.decode(blob.getBlobName(), StandardCharsets.UTF_8.toString()))) continue;
            StorageAccountInfo accountInfo = this.getStorageAccountInfo(blob.getCredentialsId());
            if (accountInfo == null) {
                response.sendError(500, "Azure Storage account global configuration is missing");
                return;
            }
            try {
                response.sendRedirect2(blob.getBlobURL() + "?" + this.generateReadSASURL(accountInfo, blob));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error downloading artifact", e);
                response.sendError(500, "Error occurred while downloading artifact " + e.getMessage());
            }
            return;
        }
        response.sendError(404, "Azure artifact is not available");
    }

    @CheckForNull
    private StorageAccountInfo getStorageAccountInfo(String credentialsId) {
        AzureStorageAccount.StorageAccountCredential accountCredentials = AzureStorageAccount.getStorageAccountCredential((Item)this.build.getParent(), credentialsId);
        if (accountCredentials == null) {
            return null;
        }
        return AzureStorageAccount.convertToStorageAccountInfo(accountCredentials);
    }

    private String generateReadSASURL(StorageAccountInfo storageAccountInfo, AzureBlob blob) throws Exception {
        if (blob.getStorageType().equalsIgnoreCase("blobstorage")) {
            return AzureUtils.generateBlobSASURL(storageAccountInfo, blob.getContainerOrFileShare(), blob.getBlobName(), new BlobSasPermission().setReadPermission(true));
        }
        if (blob.getStorageType().equalsIgnoreCase("filestorage")) {
            return AzureUtils.generateFileSASURL(storageAccountInfo, blob.getContainerOrFileShare(), blob.getBlobName(), new ShareFileSasPermission().setReadPermission(true));
        }
        throw new Exception("Unknown storage type. Please re-configure your job and build again.");
    }

    public boolean isAnonymousAccess(Authentication auth) {
        return auth != null && auth.getName() != null && "anonymous".equals(auth.getName());
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

