/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vb6;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class VB6Builder
extends Builder
implements SimpleBuildStep {
    private final String projectFile;
    private String outDir;
    private String compileConstants;

    @DataBoundConstructor
    public VB6Builder(String projectFile) {
        this.projectFile = projectFile;
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public String getOutDir() {
        return this.outDir;
    }

    @DataBoundSetter
    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public String getCompileConstants() {
        return this.compileConstants;
    }

    @DataBoundSetter
    public void setCompileConstants(String compileConstants) {
        this.compileConstants = compileConstants;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (launcher.isUnix()) {
            throw new AbortException("nice try, but come back with a Windows machine");
        }
        if (Strings.isNullOrEmpty((String)this.getProjectFile())) {
            throw new AbortException("nice try, but we need something to compile");
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        String builderPath = this.getDescriptor().getBuilderPath();
        if (builderPath != null && builderPath.trim().isEmpty()) {
            throw new AbortException("VB6.EXE path not defined");
        }
        args.add(builderPath);
        args.add("/make");
        if (!Strings.isNullOrEmpty((String)this.getOutDir())) {
            args.add("/outdir").add(this.getOutDir());
        }
        if (!Strings.isNullOrEmpty((String)this.getCompileConstants())) {
            args.add("/d").add(this.getCompileConstants());
        }
        FilePath tempPath = workspace.createTempFile("vb6build", ".log");
        args.add("/out").add(tempPath.getRemote());
        args.add(this.getProjectFile());
        args.prepend(new String[]{"cmd.exe", "/C", "\""});
        args.add(new String[]{"\"", "&&", "exit", "%%ERRORLEVEL%%"});
        int r = launcher.launch().cmds(args).pwd(workspace).join();
        listener.getLogger().println(tempPath.readToString());
        if (r != 0) {
            listener.getLogger().println(String.format("return code is %d", r));
            throw new AbortException("build not ok. return code is " + r);
        }
        tempPath.delete();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"vb6"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String builderPath;

        public DescriptorImpl() {
            this.load();
        }

        @POST
        public FormValidation doCheckProjectFile(@QueryParameter String value) {
            Jenkins.get().checkPermission(Item.CONFIGURE);
            if (Strings.isNullOrEmpty((String)value)) {
                return FormValidation.error((String)"value is empty");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "VB6";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.builderPath = formData.getString("builderPath");
            this.save();
            return super.configure(req, formData);
        }

        public String getBuilderPath() {
            return this.builderPath;
        }

        public void setBuilderPath(String builderPath) {
            this.builderPath = builderPath;
        }
    }
}

