/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.content;

import hudson.Extension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.urltrigger.content.TEXTContentEntry;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentTypeDescriptor;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class TEXTContentType
extends URLTriggerContentType {
    private static final long serialVersionUID = 3560292914545953855L;
    private List<TEXTContentEntry> regExElements = new ArrayList<TEXTContentEntry>();
    private transient Map<String, List<String>> capturedValues;

    @DataBoundConstructor
    public TEXTContentType(List<TEXTContentEntry> regExElements) {
        if (regExElements != null) {
            this.regExElements = regExElements;
        }
    }

    public List<TEXTContentEntry> getRegExElements() {
        return this.regExElements;
    }

    @Override
    protected void initForContentType(String content, XTriggerLog log) throws XTriggerException {
        this.capturedValues = this.getMatchedValue(content);
    }

    @Override
    protected boolean isTriggeringBuildForContent(String content, XTriggerLog log) throws XTriggerException {
        if (this.regExElements == null || this.regExElements.size() == 0) {
            log.error("You must configure at least one REGEX. Exit with no changes.");
            return false;
        }
        if (this.capturedValues == null) {
            log.info("Capturing URL context. Waiting next schedule to check a change.");
            return false;
        }
        Map<String, List<String>> newCapturedValues = this.getMatchedValue(content);
        if (this.capturedValues.size() != newCapturedValues.size()) {
            log.info("There are less or more matching elements.");
            return true;
        }
        for (Map.Entry<String, List<String>> entry : this.capturedValues.entrySet()) {
            String regEx = entry.getKey();
            if (!newCapturedValues.containsKey(regEx)) {
                log.info(String.format("The regular expression %s doesn't exist anymore.", regEx));
                return true;
            }
            List<String> oldValues = entry.getValue();
            List<String> newValues = newCapturedValues.get(entry.getKey());
            if (oldValues == null) {
                return false;
            }
            if (newValues == null) {
                return false;
            }
            if (newValues.size() != oldValues.size()) {
                log.info(String.format("The number of values for the regular expression %s is different.", regEx));
                return true;
            }
            for (String oldValue : oldValues) {
                if (newValues.contains(oldValue)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, List<String>> getMatchedValue(String content) throws XTriggerException {
        HashMap<String, List<String>> capturedValues = new HashMap<String, List<String>>();
        try (StringReader stringReader = new StringReader(content);
             BufferedReader bufferedReader = new BufferedReader(stringReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                for (TEXTContentEntry regexEntry : this.regExElements) {
                    Pattern pattern;
                    Matcher matcher;
                    String regEx = regexEntry.getRegEx();
                    if (regEx == null || !(matcher = (pattern = Pattern.compile(regEx)).matcher(line)).matches()) continue;
                    this.addMatchedValue(capturedValues, regEx, matcher.group());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return capturedValues;
    }

    private Map<String, List<String>> addMatchedValue(Map<String, List<String>> capturedValues, String regEx, String group) {
        List<String> values = capturedValues.get(regEx);
        if (values == null) {
            values = new ArrayList<String>();
            values.add(group);
            capturedValues.put(regEx, values);
            return capturedValues;
        }
        values.add(group);
        return capturedValues;
    }

    @Extension
    @Symbol(value={"TextContent"})
    public static class TEXTContentDescriptor
    extends URLTriggerContentTypeDescriptor<TEXTContentType> {
        @Override
        public Class<? extends URLTriggerContentType> getType() {
            return TEXTContentType.class;
        }

        public String getDisplayName() {
            return "Monitor the contents of a TEXT response";
        }

        @Override
        public String getLabel() {
            return "TXT";
        }
    }
}

