/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Run;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.util.FormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="XStream does not care")
public class PackageResult
extends BaseResult {
    public static final String NO_PKG_NAME = "No Package";
    private List<ClassResult> classList = new ArrayList<ClassResult>();
    private List<MethodResult> sortedTestMethodsByStartTime = null;
    private transient long startTime;
    private transient long duration;
    private transient int fail;
    private transient int skip;
    private transient int pass;
    public static final int MAX_EXEC_MTHD_LIST_SIZE = 25;

    public PackageResult(String name) {
        super(name);
    }

    @Override
    public void setRun(Run<?, ?> run) {
        super.setRun(run);
        for (ClassResult _class : this.classList) {
            _class.setRun(run);
        }
    }

    @Exported
    public float getDuration() {
        return (float)this.duration / 1000.0f;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.startTime + this.duration;
    }

    @Exported(visibility=9, name="fail")
    public int getFailCount() {
        return this.fail;
    }

    @Exported(visibility=9, name="skip")
    public int getSkipCount() {
        return this.skip;
    }

    @Exported(visibility=9)
    public int getTotalCount() {
        return super.getTotalCount();
    }

    public int getPassCount() {
        return this.pass;
    }

    public List<MethodResult> getSortedTestMethodsByStartTime() {
        if (this.sortedTestMethodsByStartTime == null) {
            this.sortTestMethods();
        }
        return this.sortedTestMethodsByStartTime;
    }

    @JavaScriptMethod
    public String getAllSortedTestMethodsByStartTime() {
        return this.getMethodExecutionTableContent(this.getSortedTestMethodsByStartTime());
    }

    @JavaScriptMethod
    public String getFirstXSortedTestMethodsByStartTime() {
        List<MethodResult> list;
        list = list.subList(0, (list = this.getSortedTestMethodsByStartTime()).size() > 25 ? 25 : list.size());
        return this.getMethodExecutionTableContent(list);
    }

    private String getMethodExecutionTableContent(List<MethodResult> mrList) {
        StringBuilder sb = new StringBuilder(mrList.size() * 100);
        for (MethodResult mr : mrList) {
            sb.append("<tr><td align=\"left\">");
            sb.append("<a href=\"").append(Util.escape((String)mr.getUpUrl())).append("\">");
            sb.append(Util.escape((String)mr.getParent().getName())).append(".").append(Util.escape((String)mr.getName()));
            sb.append("</a>");
            sb.append("</td><td align=\"left\">");
            sb.append(Util.escape((String)mr.getDescription()));
            sb.append("</td><td align=\"center\">");
            sb.append(FormatUtil.formatTime(mr.getDuration()));
            sb.append("</td><td align=\"center\">");
            sb.append(mr.getStartedAt());
            sb.append("</td><td align=\"center\"><span class=\"").append(mr.getCssClass()).append("\">");
            sb.append(Util.escape((String)mr.getStatus()));
            sb.append("</span></td></tr>");
        }
        return sb.toString();
    }

    public void tally() {
        this.fail = 0;
        this.skip = 0;
        this.pass = 0;
        ArrayList<long[]> timeSeries = new ArrayList<long[]>(this.classList.size());
        for (ClassResult _c : this.classList) {
            _c.setParent(this);
            _c.tally();
            this.fail += _c.getFailCount();
            this.skip += _c.getSkipCount();
            this.pass += _c.getPassCount();
            timeSeries.add(new long[]{_c.getStartTime(), _c.getEndTime() - _c.getStartTime()});
        }
        Collections.sort(timeSeries, new Comparator<long[]>(){

            @Override
            public int compare(long[] ts1, long[] ts2) {
                return ts1[0] < ts2[0] ? -1 : (ts1[0] > ts2[0] ? 1 : 0);
            }
        });
        timeSeries.add(new long[]{System.currentTimeMillis(), 0L});
        this.startTime = ((long[])timeSeries.get(0))[0];
        this.duration = 0L;
        int activeTS = 0;
        int nextTS = 1;
        do {
            long[] ts1 = (long[])timeSeries.get(activeTS);
            long[] ts2 = (long[])timeSeries.get(nextTS);
            long s1 = ts1[0];
            long e1 = ts1[0] + ts1[1];
            long s2 = ts2[0];
            long e2 = ts2[0] + ts2[1];
            if (s1 <= s2 && e1 >= e2) {
                ++nextTS;
                continue;
            }
            this.duration = e1 <= s2 ? (this.duration += ts1[1]) : (this.duration += s2 - s1);
            activeTS = nextTS++;
        } while (nextTS < timeSeries.size());
    }

    public void sortTestMethods() {
        this.sortedTestMethodsByStartTime = new ArrayList<MethodResult>();
        HashMap map = new HashMap();
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                Date startDate = aMethod.getStartedAt();
                if (aMethod.getStatus().equalsIgnoreCase("skip") || startDate == null) continue;
                if (map.containsKey(startDate)) {
                    ((List)map.get(startDate)).add(aMethod);
                    continue;
                }
                ArrayList<MethodResult> list = new ArrayList<MethodResult>();
                list.add(aMethod);
                map.put(startDate, list);
            }
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (Date key : keys) {
            if (!map.containsKey(key)) continue;
            this.sortedTestMethodsByStartTime.addAll((Collection)map.get(key));
        }
    }

    @Exported(name="classs")
    public List<ClassResult> getChildren() {
        return this.classList;
    }

    public boolean hasChildren() {
        return this.classList != null && !this.classList.isEmpty();
    }

    @Override
    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        if (token.indexOf(46) == -1) {
            return super.getDynamic(token, req, rsp);
        }
        if (this.classList != null) {
            for (ClassResult classResult : this.classList) {
                if (!token.equals(classResult.getPkgName() + "." + classResult.getName())) continue;
                return classResult;
            }
        }
        return null;
    }
}

