/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundle;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRule;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRuleImageConfigFailure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PolicyBundleRuleImageConfig
implements PolicyBundleRule {
    private final String id;
    private final String description;
    private final EvaluationResult evaluationResult;
    private final PolicyBundle parent;
    private final List<PolicyBundleRuleImageConfigFailure> failures;

    PolicyBundleRuleImageConfig(String id, String description, EvaluationResult evaluationResult, PolicyBundle parent) {
        this.id = id;
        this.description = description;
        this.evaluationResult = evaluationResult;
        this.parent = parent;
        this.failures = new ArrayList<PolicyBundleRuleImageConfigFailure>();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public EvaluationResult evaluationResult() {
        return this.evaluationResult;
    }

    @Override
    public PolicyBundle parent() {
        return this.parent;
    }

    public PolicyBundleRuleImageConfigFailure addFailure(String remediation) {
        PolicyBundleRuleImageConfigFailure failure = new PolicyBundleRuleImageConfigFailure(remediation, this);
        this.failures.add(failure);
        return failure;
    }

    public List<PolicyBundleRuleImageConfigFailure> failures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyBundleRuleImageConfig that = (PolicyBundleRuleImageConfig)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && this.evaluationResult == that.evaluationResult && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.evaluationResult, this.parent);
    }
}

