/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.application.vm.report;

import com.sysdig.jenkins.plugins.sysdig.application.vm.ReportProcessor;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReport;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReportLine;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Policy;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import java.util.Collection;
import java.util.stream.Stream;

public class PolicyReportProcessor
implements ReportProcessor {
    private final SysdigLogger logger;

    public PolicyReportProcessor(SysdigLogger logger) {
        this.logger = logger;
    }

    @Override
    public PolicyEvaluationReport processPolicyEvaluation(ScanResult result) {
        Collection<Policy> evaluationPolicies = result.policies();
        this.logger.logDebug(String.format("sysdig-secure-engine policies for '%s': %s ", result.metadata().pullString(), evaluationPolicies.toString()));
        return this.generatePolicyEvaluationReport(result);
    }

    private PolicyEvaluationReport generatePolicyEvaluationReport(ScanResult scanResult) {
        PolicyEvaluationReport result = new PolicyEvaluationReport(scanResult.evaluationResult().isFailed());
        Stream rows = scanResult.policies().stream().filter(policy -> policy.evaluationResult().isFailed()).flatMap(failedPolicy -> failedPolicy.bundles().stream().filter(bundle -> bundle.evaluationResult().isFailed()).flatMap(failedBundle -> failedBundle.rules().stream().filter(rule -> rule.evaluationResult().isFailed()).flatMap(failedRule -> failedRule.failures().stream().map(failure -> new PolicyEvaluationReportLine(scanResult.metadata().imageID(), scanResult.metadata().pullString(), "trigger_id", failedBundle.name(), failedRule.description(), failure.description(), "STOP", false, failedPolicy.id(), failedPolicy.name())))));
        rows.forEach(result::addResult);
        return result;
    }
}

