/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.application.vm;

import com.sysdig.jenkins.plugins.sysdig.application.vm.ReportProcessor;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ReportStorage;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReport;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.ScanResultArchiver;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public class ImageScanningArchiver
implements ScanResultArchiver {
    private final ReportProcessor policyEvaluationReportProcessor;
    private final ReportStorage reportStorage;

    public ImageScanningArchiver(@NonNull ReportProcessor policyEvaluationReportProcessor, @NonNull ReportStorage reportStorage) {
        this.policyEvaluationReportProcessor = policyEvaluationReportProcessor;
        this.reportStorage = reportStorage;
    }

    @Override
    public void archiveScanResult(ScanResult scanResult, String scanResultDiffFileName) throws IOException, InterruptedException {
        PolicyEvaluationReport policyEvaluationReport = this.policyEvaluationReportProcessor.processPolicyEvaluation(scanResult);
        this.reportStorage.savePolicyReport(scanResult, policyEvaluationReport);
        this.reportStorage.saveVulnerabilityReport(scanResult);
        this.reportStorage.saveRawVulnerabilityReport(scanResult);
        this.reportStorage.archiveResults(scanResult, scanResultDiffFileName);
    }
}

