/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner;

import com.google.common.base.Strings;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.SysdigProcessBuilderBase;
import java.util.ArrayList;
import java.util.List;

public class SysdigImageScanningProcessBuilder
extends SysdigProcessBuilderBase<SysdigImageScanningProcessBuilder> {
    private String dbPath = "";
    private String cachePath = "";
    private String imageToScan = "";
    private boolean separateByLayer = false;

    public SysdigImageScanningProcessBuilder(String sysdigCLIPath, String sysdigAPIToken) {
        super(sysdigCLIPath, sysdigAPIToken);
    }

    public SysdigImageScanningProcessBuilder withDBPath(String dbPath) {
        SysdigImageScanningProcessBuilder clone = this.clone();
        clone.dbPath = dbPath;
        return clone;
    }

    public SysdigImageScanningProcessBuilder withCachePath(String cachePath) {
        SysdigImageScanningProcessBuilder clone = this.clone();
        clone.cachePath = cachePath;
        return clone;
    }

    public SysdigImageScanningProcessBuilder withImageToScan(String imageToScan) {
        SysdigImageScanningProcessBuilder clone = this.clone();
        clone.imageToScan = imageToScan;
        return clone;
    }

    public SysdigImageScanningProcessBuilder withSeparateByLayer(boolean separateByLayer) {
        SysdigImageScanningProcessBuilder clone = this.clone();
        clone.separateByLayer = separateByLayer;
        return clone;
    }

    @Override
    public List<String> toCommandLineArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.sysdigCLIPath);
        if (!Strings.isNullOrEmpty((String)this.engineURL)) {
            arguments.add("--apiurl=" + this.engineURL);
        }
        if (!Strings.isNullOrEmpty((String)this.scanResultOutputPath)) {
            arguments.add("--output=json-file=" + this.scanResultOutputPath);
        }
        this.policiesToApply.stream().map(policy -> "--policy=" + policy).forEach(arguments::add);
        if (!Strings.isNullOrEmpty((String)this.dbPath)) {
            arguments.add("--dbpath=" + this.dbPath);
        }
        if (!Strings.isNullOrEmpty((String)this.cachePath)) {
            arguments.add("--cachepath=" + this.cachePath);
        }
        arguments.add("--loglevel=" + this.logLevel.toString());
        if (this.consoleLogEnabled) {
            arguments.add("--console-log");
        }
        if (!this.verifyTLS) {
            arguments.add("--skiptlsverify");
        }
        if (this.separateByLayer) {
            arguments.add("--separate-by-layer");
        }
        arguments.addAll(this.extraParams);
        arguments.add(this.imageToScan);
        return arguments;
    }

    @Override
    public SysdigImageScanningProcessBuilder clone() {
        return (SysdigImageScanningProcessBuilder)super.clone();
    }
}

