/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner;

import com.google.common.base.Strings;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ImageScanningConfig;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.http.RetriableRemoteDownloader;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.json.GsonBuilder;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.SysdigImageScanningProcessBuilder;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.SysdigProcessBuilderBase;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonScanResultV1;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.FilePath;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class RemoteSysdigImageScanner {
    private static final String FIXED_SCANNED_VERSION = "1.22.6";
    private final ScannerPaths scannerPaths;
    private final String imageName;
    private final RetriableRemoteDownloader retriableRemoteDownloader;
    private final ImageScanningConfig config;
    private final SysdigLogger logger;
    private final RunContext runContext;

    public RemoteSysdigImageScanner(@NonNull RunContext runContext, RetriableRemoteDownloader retriableRemoteDownloader, String imageName, ImageScanningConfig config) {
        this.runContext = runContext;
        this.imageName = imageName;
        this.retriableRemoteDownloader = retriableRemoteDownloader;
        this.config = config;
        this.scannerPaths = new ScannerPaths(runContext.getPathFromWorkspace(new String[0]));
        this.logger = runContext.getLogger();
    }

    public ScanResult performScan() throws AbortException {
        this.createExecutionWorkspace();
        FilePath scannerBinaryFile = this.retrieveScannerBinFile();
        String imageScanningResultJSON = this.executeScan(scannerBinaryFile);
        this.logger.logDebug("Raw scan result as JSON: ");
        this.logger.logDebug(imageScanningResultJSON);
        JsonScanResultV1 jsonScanResult = (JsonScanResultV1)GsonBuilder.build().fromJson(imageScanningResultJSON, JsonScanResultV1.class);
        return jsonScanResult.toDomain().orElseThrow(() -> new AbortException(String.format("unable to obtain result from scan: %s", imageScanningResultJSON)));
    }

    private FilePath downloadInlineScan(String latestVersion) throws IOException, UnsupportedOperationException, InterruptedException {
        URL url = RemoteSysdigImageScanner.sysdigCLIScannerURLForVersion(latestVersion);
        return this.retriableRemoteDownloader.downloadExecutable(url, String.format("inlinescan-%s.bin", latestVersion));
    }

    private static URL sysdigCLIScannerURLForVersion(String latestVersion) throws MalformedURLException {
        String os = System.getProperty("os.name").toLowerCase().startsWith("mac") ? "darwin" : "linux";
        String arch = System.getProperty("os.arch").toLowerCase().startsWith("aarch64") ? "arm64" : "amd64";
        URL url = new URL("https://download.sysdig.com/scanning/bin/sysdig-cli-scanner/" + latestVersion + "/" + os + "/" + arch + "/sysdig-cli-scanner");
        return url;
    }

    private String getInlineScanPinnedVersion() {
        return FIXED_SCANNED_VERSION;
    }

    private String getInlineScanVersion() {
        if (Strings.isNullOrEmpty((String)this.config.getCliVersionToApply())) {
            return this.getInlineScanPinnedVersion();
        }
        if (!this.config.getCliVersionToApply().equals("custom")) {
            return this.getInlineScanPinnedVersion();
        }
        if (this.config.getCustomCliVersion().isEmpty()) {
            return this.getInlineScanPinnedVersion();
        }
        return this.config.getCustomCliVersion();
    }

    private void createExecutionWorkspace() throws AbortException {
        try {
            this.scannerPaths.create();
        }
        catch (Exception e) {
            this.logger.logError("Unable to create scanner execution workspace", e);
            throw new AbortException("Unable to create scanner execution workspace");
        }
    }

    private FilePath retrieveScannerBinFile() throws AbortException {
        if (!Strings.isNullOrEmpty((String)this.config.getScannerBinaryPath())) {
            FilePath scannerBinaryPath = this.runContext.getPathFromWorkspace(this.config.getScannerBinaryPath());
            this.logger.logInfo("Inlinescan binary globally defined to* " + scannerBinaryPath.getRemote());
            return scannerBinaryPath;
        }
        try {
            String latestVersion = this.getInlineScanVersion();
            this.logger.logInfo("Downloading inlinescan v" + latestVersion);
            FilePath scannerBinaryPath = this.downloadInlineScan(latestVersion);
            this.logger.logInfo("Inlinescan binary downloaded to " + scannerBinaryPath.getRemote());
            return scannerBinaryPath;
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException("Error downloading inlinescan binary: " + String.valueOf(e));
        }
    }

    private String executeScan(FilePath scannerBinFile) throws AbortException {
        try {
            FilePath scannerJsonOutputFile = this.scannerPaths.getBaseFolder().child("inlinescan.json");
            SysdigImageScanningProcessBuilder processBuilder = this.createProcessBuilder(scannerBinFile, scannerJsonOutputFile);
            this.logger.logInfo("Executing: " + String.join((CharSequence)" ", processBuilder.toCommandLineArguments()));
            this.logger.logInfo("Waiting for scanner execution to be completed...");
            int scannerExitCode = processBuilder.launchAndWait(this.runContext.getLauncher());
            this.logger.logInfo(String.format("Scanner exit code: %d", scannerExitCode));
            String jsonOutput = "";
            if (scannerJsonOutputFile.exists()) {
                jsonOutput = scannerJsonOutputFile.readToString();
            }
            this.logger.logDebug("Inline scan JSON output:\n" + jsonOutput);
            if (scannerExitCode == 2) {
                jsonOutput = "{error:\"Wrong parameters in call to inline scanner\"}";
            } else if (scannerExitCode == 3) {
                jsonOutput = "{error:\"Unexpected error when executing scan. Check that the API token is provided and is valid for the specified URL.\"}";
            } else if (scannerExitCode != 0 && scannerExitCode != 1) {
                throw new Exception("Cannot manage return code");
            }
            return jsonOutput;
        }
        catch (Exception e) {
            throw new AbortException("Error executing inlinescan binary: " + String.valueOf(e));
        }
    }

    private SysdigImageScanningProcessBuilder createProcessBuilder(FilePath scannerBinFile, FilePath scannerJsonOutputFile) {
        SysdigImageScanningProcessBuilder processBuilder = (SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)((SysdigImageScanningProcessBuilder)new SysdigImageScanningProcessBuilder(scannerBinFile.getRemote(), this.config.getSysdigToken()).withExtraEnvVars(this.runContext.getEnvVars())).withEngineURL(this.config.getEngineurl())).withDBPath(this.scannerPaths.getDatabaseFolder().getRemote()).withCachePath(this.scannerPaths.getCacheFolder().getRemote()).withScanResultOutputPath(scannerJsonOutputFile.getRemote())).withConsoleLog()).withExtraParametersSeparatedBySpace(this.config.getInlineScanExtraParams())).withPoliciesToApplySeparatedBySpace(this.config.getPoliciesToApply())).withStdoutRedirectedTo(this.logger)).withStderrRedirectedTo(this.logger)).withLogLevel(this.config.getDebug() ? SysdigProcessBuilderBase.LogLevel.DEBUG : SysdigProcessBuilderBase.LogLevel.INFO)).withTLSVerification(this.config.getEngineverify());
        return processBuilder.withImageToScan(this.imageName);
    }

    private static class ScannerPaths
    implements Serializable {
        private static final String SCANNER_EXEC_FOLDER_BASE_PATH_PATTERN = "sysdig-secure-scan-%d";
        private final FilePath baseFolder;
        private final FilePath databaseFolder;
        private final FilePath cacheFolder;

        public ScannerPaths(FilePath basePath) {
            this.baseFolder = basePath.child(String.format(SCANNER_EXEC_FOLDER_BASE_PATH_PATTERN, System.currentTimeMillis()));
            this.databaseFolder = this.baseFolder.child("db");
            this.cacheFolder = this.baseFolder.child("cache");
        }

        public FilePath getBaseFolder() {
            return this.baseFolder;
        }

        public FilePath getDatabaseFolder() {
            return this.databaseFolder;
        }

        public FilePath getCacheFolder() {
            return this.cacheFolder;
        }

        public void create() throws Exception {
            this.baseFolder.mkdirs();
            this.databaseFolder.mkdirs();
            this.cacheFolder.mkdirs();
        }
    }
}

