/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.entrypoint;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ImageScanningApplicationService;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.ImageImageScanningConfig;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.JenkinsReportStorage;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.SysdigImageScanner;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class ImageScanningBuilder
extends Builder
implements SimpleBuildStep {
    private final String imageName;
    private boolean bailOnFail = true;
    private boolean bailOnPluginFail = true;
    private String engineURL = "";
    private String engineCredentialsId = "";
    private boolean engineVerify = true;
    private String inlineScanExtraParams = "";
    private String imageToCompare = "";
    private String policiesToApply = "";
    private String cliVersionToApply = "";
    private String customCliVersion = "";
    private String scannerBinaryPath = "";

    @DataBoundConstructor
    public ImageScanningBuilder(String imageName) {
        this.imageName = imageName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean getBailOnFail() {
        return this.bailOnFail;
    }

    @DataBoundSetter
    public void setBailOnFail(boolean bailOnFail) {
        this.bailOnFail = bailOnFail;
    }

    public boolean getBailOnPluginFail() {
        return this.bailOnPluginFail;
    }

    @DataBoundSetter
    public void setBailOnPluginFail(boolean bailOnPluginFail) {
        this.bailOnPluginFail = bailOnPluginFail;
    }

    public String getPoliciesToApply() {
        return this.policiesToApply;
    }

    @DataBoundSetter
    public void setImageToCompare(String imageToCompare) {
        this.imageToCompare = imageToCompare;
    }

    public String getImageToCompare() {
        return this.imageToCompare;
    }

    @DataBoundSetter
    public void setPoliciesToApply(String policiesToApply) {
        this.policiesToApply = policiesToApply;
    }

    public String getCliVersionToApply() {
        return this.cliVersionToApply;
    }

    @DataBoundSetter
    public void setCliVersionToApply(String cliVersionToApply) {
        this.cliVersionToApply = cliVersionToApply;
    }

    public String getCustomCliVersion() {
        return this.customCliVersion;
    }

    @DataBoundSetter
    public void setCustomCliVersion(String customCliVersion) {
        this.customCliVersion = customCliVersion;
    }

    public String getEngineURL() {
        return this.engineURL;
    }

    @DataBoundSetter
    public void setEngineURL(String engineURL) {
        this.engineURL = engineURL;
    }

    public String getEngineCredentialsId() {
        return this.engineCredentialsId;
    }

    @DataBoundSetter
    public void setEngineCredentialsId(String engineCredentialsId) {
        this.engineCredentialsId = engineCredentialsId;
    }

    public boolean getEngineVerify() {
        return this.engineVerify;
    }

    @DataBoundSetter
    public void setEngineVerify(boolean engineVerify) {
        this.engineVerify = engineVerify;
    }

    public String getInlineScanExtraParams() {
        return this.inlineScanExtraParams;
    }

    @DataBoundSetter
    public void setInlineScanExtraParams(String inlineScanExtraParams) {
        this.inlineScanExtraParams = inlineScanExtraParams;
    }

    public String getScannerBinaryPath() {
        return this.scannerBinaryPath;
    }

    @DataBoundSetter
    public void setScannerBinaryPath(String scannerBinaryPath) {
        this.scannerBinaryPath = scannerBinaryPath;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars envVars, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException {
        RunContext runContext = new RunContext(run, workspace, envVars, launcher, listener);
        SysdigLogger logger = runContext.getLogger();
        ImageImageScanningConfig config = new ImageImageScanningConfig(runContext, this);
        JenkinsReportStorage reportStorage = new JenkinsReportStorage(runContext);
        SysdigImageScanner scanner = new SysdigImageScanner(runContext, config);
        try (JenkinsReportStorage jenkinsReportStorage = reportStorage;){
            ImageScanningApplicationService scanningApplicationService = new ImageScanningApplicationService(reportStorage, scanner, logger);
            logger.logWarn(String.format("Starting Sysdig Secure Container Image Scanner step, project: %s, job: %d", runContext.getProjectName(), runContext.getJobNumber()));
            scanningApplicationService.runScan(config);
            logger.logWarn(String.format("Completed Sysdig Secure Container Image Scanner step, project: %s, job: %d", runContext.getProjectName(), runContext.getJobNumber()));
        }
    }

    public GlobalConfiguration getDescriptor() {
        return (GlobalConfiguration)super.getDescriptor();
    }

    @Extension
    public static final class GlobalConfiguration
    extends BuildStepDescriptor<Builder> {
        public static final boolean DEFAULT_BAIL_ON_FAIL = true;
        public static final boolean DEFAULT_BAIL_ON_PLUGIN_FAIL = true;
        public static final String DEFAULT_ENGINE_URL = "https://secure.sysdig.com";
        public static final boolean DEFAULT_ENGINE_VERIFY = true;
        private String engineURL = "https://secure.sysdig.com";
        private String engineCredentialsId = "";
        private boolean engineVerify = true;
        private String inlineScanExtraParams = "";
        private String scannerBinaryPath = "";
        private String policiesToApply = "";
        private String cliVersionToApply = "";
        private String customCliVersion = "";

        public GlobalConfiguration() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Sysdig Image Scanning";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public FormValidation doCheckImageName(@QueryParameter String value) {
            return Strings.isNullOrEmpty((String)value) ? FormValidation.error((String)"Please enter a valid image name") : FormValidation.ok();
        }

        public ListBoxModel doFillEngineCredentialsIdItems(@QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        public String getPoliciesToApply() {
            return this.policiesToApply;
        }

        @DataBoundSetter
        public void setPoliciesToApply(String policiesToApply) {
            this.policiesToApply = policiesToApply;
        }

        @DataBoundSetter
        public void setCliVersionToApply(String cliVersionToApply) {
            this.cliVersionToApply = cliVersionToApply;
        }

        @DataBoundSetter
        public void setCustomCliVersion(String customCliVersion) {
            this.customCliVersion = customCliVersion;
        }

        public String getEngineURL() {
            return this.engineURL;
        }

        @DataBoundSetter
        public void setEngineURL(String engineURL) {
            this.engineURL = engineURL;
        }

        public String getEngineCredentialsId() {
            return this.engineCredentialsId;
        }

        @DataBoundSetter
        public void setEngineCredentialsId(String engineCredentialsId) {
            this.engineCredentialsId = engineCredentialsId;
        }

        public boolean getEngineVerify() {
            return this.engineVerify;
        }

        @DataBoundSetter
        public void setEngineVerify(boolean engineVerify) {
            this.engineVerify = engineVerify;
        }

        public String getInlineScanExtraParams() {
            return this.inlineScanExtraParams;
        }

        @DataBoundSetter
        public void setInlineScanExtraParams(String inlineScanExtraParams) {
            this.inlineScanExtraParams = inlineScanExtraParams;
        }

        public String getScannerBinaryPath() {
            return this.scannerBinaryPath;
        }

        @DataBoundSetter
        public void setScannerBinaryPath(String scannerBinaryPath) {
            this.scannerBinaryPath = scannerBinaryPath;
        }

        public String getCliVersionToApply() {
            return this.cliVersionToApply;
        }

        public String getCustomCliVersion() {
            return this.customCliVersion;
        }
    }
}

