/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.log.ConsoleLog;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.Collections;
import jenkins.tasks.SimpleBuildStep;

public class RunContext {
    private final transient Run<?, ?> run;
    private final FilePath workspace;
    private final TaskListener listener;
    private final EnvVars envVars;
    private final SysdigLogger logger;
    private final Launcher launcher;

    public RunContext(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars envVars, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
        this.envVars = envVars;
        this.launcher = launcher;
        this.logger = new ConsoleLog("SysdigSecurePlugin", listener, false);
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public FilePath getPathFromWorkspace(String ... subpaths) {
        FilePath finalPath = this.workspace;
        for (String subpath : subpaths) {
            finalPath = new FilePath(finalPath, subpath);
        }
        return finalPath;
    }

    public EnvVars getEnvVars() {
        return this.envVars;
    }

    public SysdigLogger getLogger() {
        return this.logger;
    }

    public String getSysdigTokenFromCredentials(@NonNull String credID) throws AbortException {
        this.logger.logDebug("Processing Jenkins credential ID " + credID);
        if (Strings.isNullOrEmpty((String)credID)) {
            throw new AbortException("API Credentials not defined. Make sure credentials are defined globally or in job.");
        }
        StandardUsernamePasswordCredentials creds = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credID, StandardUsernamePasswordCredentials.class, this.run, Collections.emptyList());
        if (creds == null) {
            throw new AbortException(String.format("Cannot find Jenkins credentials by ID: '%s'. Ensure credentials are defined in Jenkins before using them", credID));
        }
        return creds.getPassword().getPlainText();
    }

    public void perform(@NonNull SimpleBuildStep buildStep) throws IOException, InterruptedException {
        buildStep.perform(this.run, this.workspace, this.envVars, this.getLauncher(), this.listener);
    }

    public String getProjectName() {
        return this.run.getParent().getDisplayName();
    }

    public int getJobNumber() {
        return this.run.getNumber();
    }

    public <V, E extends Throwable> V call(@NonNull Callable<V, E> act) throws IOException, InterruptedException, E {
        return (V)this.workspace.act(act);
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

