/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.application.vm.report;

import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReportLine;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyEvaluationReport {
    private final Map<String, List<PolicyEvaluationReportLine>> resultsForEachImage;
    private final boolean failed;

    public PolicyEvaluationReport(boolean failed) {
        this.failed = failed;
        this.resultsForEachImage = new HashMap<String, List<PolicyEvaluationReportLine>>();
    }

    public Map<String, List<PolicyEvaluationReportLine>> getResultsForEachImage() {
        return this.resultsForEachImage;
    }

    public void addResult(@NonNull PolicyEvaluationReportLine result) {
        this.resultsForEachImage.putIfAbsent(result.imageID(), new ArrayList());
        this.resultsForEachImage.get(result.imageID()).add(result);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isPassed() {
        return !this.isFailed();
    }
}

