/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

abstract class Setter {
    Setter() {
    }

    abstract void set(Object var1, Object var2) throws Exception;

    abstract String getDisplayName();

    abstract boolean isDeprecated();

    static Setter create(final Method m) {
        m.setAccessible(true);
        return new Setter(){

            @Override
            void set(Object instance, Object value) throws Exception {
                m.invoke(instance, value);
            }

            @Override
            String getDisplayName() {
                return String.valueOf(m.getDeclaringClass()) + "." + m.getName() + "()";
            }

            @Override
            boolean isDeprecated() {
                return m.getAnnotation(Deprecated.class) != null;
            }
        };
    }

    static Setter create(final Field f) {
        f.setAccessible(true);
        return new Setter(){

            @Override
            void set(Object instance, Object value) throws Exception {
                f.set(instance, value);
            }

            @Override
            String getDisplayName() {
                return String.valueOf(f.getDeclaringClass()) + "." + f.getName();
            }

            @Override
            boolean isDeprecated() {
                return f.getAnnotation(Deprecated.class) != null;
            }
        };
    }
}

