/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;
import org.jenkinsci.plugins.sshsteps.util.SSHMasterToSlaveCallable;
import org.jenkinsci.plugins.sshsteps.util.SSHStepDescriptorImpl;
import org.jenkinsci.plugins.sshsteps.util.SSHStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ScriptStep
extends BasicSSHStep {
    private static final long serialVersionUID = 7358533459289529723L;
    private final String script;

    @DataBoundConstructor
    public ScriptStep(String script) {
        this.script = script;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    public static class Execution
    extends SSHStepExecution {
        private static final long serialVersionUID = 6008070200393301960L;

        protected Execution(ScriptStep step, StepContext context) throws IOException, InterruptedException {
            super(step, context);
        }

        protected Object run() throws Exception {
            ScriptStep step = (ScriptStep)this.getStep();
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            if (Util.fixEmpty((String)step.getScript()) == null) {
                throw new IllegalArgumentException("script is null or empty");
            }
            FilePath path = ws.child(step.getScript());
            if (!path.exists()) {
                throw new IllegalArgumentException(path.getRemote() + " does not exist.");
            }
            if (path.isDirectory()) {
                throw new IllegalArgumentException(path.getRemote() + " is a directory.");
            }
            return this.getChannel().call((Callable)new ScriptCallable(step, this.getListener(), path.getRemote()));
        }

        private static class ScriptCallable
        extends SSHMasterToSlaveCallable {
            private final String script;

            public ScriptCallable(ScriptStep step, TaskListener listener, String script) {
                super(step, listener);
                this.script = script;
            }

            @Override
            public Object execute() {
                return this.getService().executeScriptFromFile(this.script);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SSHStepDescriptorImpl {
        public String getFunctionName() {
            return "sshScript";
        }

        @NonNull
        public String getDisplayName() {
            return this.getPrefix() + this.getFunctionName() + " - Execute script(file) on remote node.";
        }
    }
}

