/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.trilead.ssh2.KnownHosts;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;

public final class HostKey
implements Serializable {
    private static final long serialVersionUID = -5131839381842616910L;
    private final String algorithm;
    private final byte[] key;

    public HostKey(String algorithm, byte[] key) {
        this.algorithm = algorithm;
        this.key = (byte[])key.clone();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public String getFingerprint() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(this.getKey());
            return "SHA256:" + Base64.getEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            return KnownHosts.createHexFingerprint((String)this.getAlgorithm(), (byte[])this.getKey());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostKey other = (HostKey)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        return Arrays.equals(this.key, other.key);
    }
}

