/*
 * Decompiled with CFR 0.152.
 */
package test.ssh_agent;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Functions;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.jvnet.hudson.test.JenkinsRule;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;

public final class OutboundAgent
implements AutoCloseable {
    private String image = "jenkins/ssh-agent";
    private SSHAgentContainer container;

    public OutboundAgent withImage(String image) {
        this.image = image;
        return this;
    }

    public ConnectionDetails start() throws Exception {
        if (!Functions.isWindows() && DockerClientFactory.instance().isDockerAvailable()) {
            this.container = new SSHAgentContainer(this.image);
            this.container.start();
            return new ConnectionDetails(this.container.getHost(), this.container.getMappedPort(22), this.container.privateKey);
        }
        return null;
    }

    public static void createAgent(JenkinsRule rule, String name, ConnectionDetails connectionDetails) throws Exception {
        if (connectionDetails != null) {
            BasicSSHUserPrivateKey creds = new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, null, "jenkins", (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(connectionDetails.privateKey), null, null);
            ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)rule.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)creds);
            rule.jenkins.addNode((Node)new DumbSlave(name, "/home/jenkins/agent", (ComputerLauncher)new SSHLauncher(connectionDetails.host, connectionDetails.port, creds.getId())));
        } else {
            rule.createSlave(name, null, null);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.container != null) {
            this.container.close();
        }
    }

    private static final class SSHAgentContainer
    extends GenericContainer<SSHAgentContainer> {
        final String privateKey;

        SSHAgentContainer(String image) {
            super(image);
            try {
                KeyPair kp = KeyUtils.generateKeyPair((String)"ssh-rsa", (int)2048);
                OpenSSHKeyPairResourceWriter kprw = new OpenSSHKeyPairResourceWriter();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                kprw.writePublicKey(kp, null, (OutputStream)baos);
                String pub = baos.toString(StandardCharsets.US_ASCII);
                baos.reset();
                kprw.writePrivateKey(kp, null, null, (OutputStream)baos);
                this.privateKey = baos.toString(StandardCharsets.US_ASCII);
                this.withEnv("JENKINS_AGENT_SSH_PUBKEY", pub);
                this.withExposedPorts(new Integer[]{22});
            }
            catch (Exception x) {
                throw new AssertionError((Object)x);
            }
        }
    }

    public record ConnectionDetails(String host, int port, String privateKey) implements Serializable
    {
    }
}

