/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ssegateway.sse;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jenkinsci.plugins.ssegateway.sse.EventDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsynchEventDispatcher
extends EventDispatcher {
    private static final long serialVersionUID = -1L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AsynchEventDispatcher.class.getName());
    private static final long TIMEOUT = 30000L;
    private transient AsyncContext asyncContext;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Doesn't make sense to persist it")
    private final transient Lock asyncContextLock = new ReentrantLock();

    AsynchEventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(HttpServletRequest request, HttpServletResponse response) {
        final AsynchEventDispatcher dispatcher = this;
        this.asyncContextLock.lock();
        try {
            this.asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
            this.asyncContext.setTimeout(30000L);
            this.asyncContext.addListener(new AsyncListener(){

                public void onTimeout(AsyncEvent event) throws IOException {
                    AsynchEventDispatcher.this.asyncContextLock.lock();
                    try {
                        LOGGER.debug("Async dispatcher 'onTimeout' event: {}", (Object)event);
                        if (event.getAsyncContext() == AsynchEventDispatcher.this.asyncContext) {
                            AsynchEventDispatcher.this.asyncContext = null;
                        }
                        event.getAsyncContext().complete();
                    }
                    finally {
                        AsynchEventDispatcher.this.asyncContextLock.unlock();
                    }
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                    LOGGER.debug("Async dispatcher 'onStartAsync' event: {}", (Object)event);
                }

                public void onError(AsyncEvent event) throws IOException {
                    LOGGER.warn("Async dispatcher 'onError' event: {}", (Object)dispatcher);
                }

                public void onComplete(AsyncEvent event) throws IOException {
                    LOGGER.debug("Async dispatcher 'onComplete' event: {}", (Object)event);
                }
            });
        }
        finally {
            this.asyncContextLock.unlock();
        }
    }

    @Override
    public HttpServletResponse getResponse() {
        if (this.asyncContext == null) {
            return null;
        }
        return (HttpServletResponse)this.asyncContext.getResponse();
    }

    @Override
    public void stop() {
        this.asyncContext.complete();
    }
}

