/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultCause;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricIdsHistoryProvider;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.TextFileReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;

public class MetricIdsHistory
implements IMetricIdsHistoryProvider {
    public static final String ADD_METRIC_IDS_HAD_NO_EFFECT_ON_FILE = "Add metricIds had no effect on file ";
    public static final String OVERRIDE_METRIC_IDS_FILE = "Override metricIds file ";
    private final File file;
    private long lastModified = 0L;
    private MetricIds cachedMetricIds = null;

    public MetricIdsHistory(File historyFile) {
        this.file = historyFile;
        if (!this.file.isFile()) {
            SonargraphLogger.INSTANCE.log(Level.FINE, "Create new empty MetricIds JSON file {0}", this.file.getAbsolutePath());
            this.storeMetricIds(new MetricIds());
        }
    }

    @Override
    public ResultWithOutcome<MetricIds> readMetricIds() {
        ResultWithOutcome result = new ResultWithOutcome("Read metricIds");
        long modified = this.file.lastModified();
        if (modified != this.lastModified || this.cachedMetricIds == null) {
            this.lastModified = modified;
            try {
                SonargraphLogger.INSTANCE.log(Level.FINE, "Read metricIds file {0}", this.getStorageName());
                String jsonString = TextFileReader.readLargeTextFile(this.file);
                this.cachedMetricIds = MetricIds.fromJSON(jsonString);
                result.setOutcome((Serializable)this.cachedMetricIds);
            }
            catch (IOException ioe) {
                SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to read metricIds file '" + this.getStorageName(), ioe);
                this.cachedMetricIds = null;
                this.lastModified = 0L;
                result.addError((Result.ICause)ResultCause.IO_EXCEPTION, (Throwable)ioe);
            }
        } else {
            SonargraphLogger.INSTANCE.log(Level.FINE, "Use cached metricIds");
            result.setOutcome((Serializable)this.cachedMetricIds);
        }
        return result;
    }

    @Override
    public MetricIds addMetricIds(MetricIds metricIds, PrintStream logger) {
        ResultWithOutcome<MetricIds> existing = this.readMetricIds();
        if (existing.isSuccess()) {
            MetricIds newMetricIds = new MetricIds();
            MetricIds existingMetricIds = (MetricIds)existing.getOutcome();
            newMetricIds.addAll(existingMetricIds);
            newMetricIds.addAll(metricIds);
            if (!existingMetricIds.equals(newMetricIds)) {
                SonargraphLogger.logToConsoleOutput(logger, Level.FINE, OVERRIDE_METRIC_IDS_FILE + this.file.getAbsolutePath(), null);
                this.storeMetricIds(newMetricIds);
            } else {
                SonargraphLogger.logToConsoleOutput(logger, Level.FINE, ADD_METRIC_IDS_HAD_NO_EFFECT_ON_FILE + this.file.getAbsolutePath(), null);
            }
            return newMetricIds;
        }
        return metricIds;
    }

    private void storeMetricIds(MetricIds metricIds) {
        SonargraphLogger.INSTANCE.log(Level.INFO, "Store {0} metricIds to file {1}", new Object[]{metricIds.getMetricIds().size(), this.file.getAbsolutePath()});
        String jsonString = MetricIds.toJSON(metricIds);
        try (PrintWriter out = new PrintWriter(this.file, StandardCharsets.UTF_8);){
            out.println(jsonString);
        }
        catch (IOException ex) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to create new MetricIds JSON file " + this.file.getAbsolutePath(), ex);
        }
    }

    @Override
    public String getStorageName() {
        return this.file.getAbsolutePath();
    }
}

