/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.foundation;

import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import hudson.model.Job;
import java.io.File;

public final class LatestFolder {
    private LatestFolder() {
    }

    public static File getFolder(Job<?, ?> job) {
        File jobRootFolder = job.getRootDir();
        File reportHistoryFolder = new File(jobRootFolder, ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        File latestFolder = new File(reportHistoryFolder, "latest");
        return latestFolder;
    }

    public static File getReport(Job<?, ?> job) {
        File latestFolder = LatestFolder.getFolder(job);
        String reportFileName = ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue() + ".html";
        File reportFile = new File(latestFolder, reportFileName);
        return reportFile;
    }

    public static boolean hasReport(Job<?, ?> job) {
        File reportFile = LatestFolder.getReport(job);
        return reportFile.exists() && reportFile.isFile() && reportFile.canRead();
    }

    public static File getDiffReport(Job<?, ?> job) {
        File latestFolder = LatestFolder.getFolder(job);
        String reportFileName = ConfigParameters.SONARGRAPH_DIFF_FILE_NAME.getValue() + ".html";
        File reportFile = new File(latestFolder, reportFileName);
        return reportFile;
    }

    public static boolean hasDiffReport(Job<?, ?> job) {
        File reportFile = LatestFolder.getDiffReport(job);
        return reportFile.exists() && reportFile.isFile() && reportFile.canRead();
    }
}

