/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractBuildStepDescriptor;
import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractSonargraphRecorder;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.IReportPathProvider;
import com.hello2morrow.sonargraph.integration.jenkins.controller.InvisibleDiffAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.InvisibleReportAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.JobCategory;
import com.hello2morrow.sonargraph.integration.jenkins.controller.Metric;
import com.hello2morrow.sonargraph.integration.jenkins.controller.MetricIdProvider;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphBadgeAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphDiffAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphIntegrationAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphReportAction;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphUtil;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.ConfigurationFileWriter;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import com.hello2morrow.sonargraph.integration.jenkins.tool.SonargraphBuild;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.ProxyConfiguration;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Symbol(value={"SonargraphReport"})
public final class SonargraphReportBuilder
extends AbstractSonargraphRecorder
implements IReportPathProvider,
SimpleBuildStep,
SimpleBuildStep.LastBuildAction,
RunAction2,
Serializable {
    private static final long serialVersionUID = -4080719672719164118L;
    private static final String ORG_ECLIPSE_OSGI_JAR = "org.eclipse.osgi_*.jar";
    private static final String SONARGRAPH_BUILD_CLIENT_JAR = "com.hello2morrow.sonargraph.build.client_*.jar";
    private static final String SONARGRAPH_BUILD_MAIN_CLASS = "com.hello2morrow.sonargraph.build.client.SonargraphBuildRunner";
    public static final int MAX_PORT_NUMBER = 65535;
    public static final String DO_NOT_SPLIT = "-1";
    private transient Run<?, ?> run;
    private String systemDirectory = "";
    private String qualityModelFile = "";
    private String virtualModel = "Modifiable.vm";
    private String reportPath = "./target/sonargraph/sonargraph-report";
    private String baselineReportPath = "";
    private String reportGeneration = "generatedBySonargraphBuild";
    private String chartConfiguration = "allCharts";
    private List<Metric> metrics;
    private String metaDataFile = "";
    private boolean languageJava;
    private boolean languageCSharp;
    private boolean languageCPlusPlus;
    private boolean languagePython;
    private String sonargraphBuildJDK = "";
    private String sonargraphBuildVersion = "";
    private String activationCode = "";
    private String licenseFile = "";
    private String workspaceProfile = "";
    private String snapshotDirectory = "";
    private String snapshotFileName = "";
    private String logLevel = "info";
    private String logFile = "sonargraph_build.log";
    private boolean skip;
    private boolean useHttpProxy = true;

    @DataBoundConstructor
    public SonargraphReportBuilder() {
    }

    @DataBoundSetter
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @DataBoundSetter
    public void setUseHttpProxy(boolean useHttpProxy) {
        this.useHttpProxy = useHttpProxy;
    }

    @DataBoundSetter
    public void setSystemDirectory(String systemDirectory) {
        this.systemDirectory = systemDirectory;
    }

    @DataBoundSetter
    public void setQualityModelFile(String qualityModelFile) {
        this.qualityModelFile = qualityModelFile;
    }

    @DataBoundSetter
    public void setVirtualModel(String virtualModel) {
        this.virtualModel = virtualModel;
    }

    @DataBoundSetter
    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    @DataBoundSetter
    public void setBaselineReportPath(String baselineReportPath) {
        this.baselineReportPath = baselineReportPath;
    }

    @DataBoundSetter
    public void setReportGeneration(String reportGeneration) {
        this.reportGeneration = reportGeneration;
    }

    @DataBoundSetter
    public void setChartConfiguration(String chartConfiguration) {
        this.chartConfiguration = chartConfiguration;
    }

    @DataBoundSetter
    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    @DataBoundSetter
    public void setMetaDataFile(String metaDataFile) {
        this.metaDataFile = metaDataFile;
    }

    @DataBoundSetter
    public void setLanguageJava(boolean languageJava) {
        this.languageJava = languageJava;
    }

    @DataBoundSetter
    public void setLanguageCSharp(boolean languageCSharp) {
        this.languageCSharp = languageCSharp;
    }

    @DataBoundSetter
    public void setLanguageCPlusPlus(boolean languageCPlusPlus) {
        this.languageCPlusPlus = languageCPlusPlus;
    }

    @DataBoundSetter
    public void setLanguagePython(boolean languagePython) {
        this.languagePython = languagePython;
    }

    @DataBoundSetter
    public void setSonargraphBuildJDK(String sonargraphBuildJDK) {
        this.sonargraphBuildJDK = sonargraphBuildJDK;
    }

    @DataBoundSetter
    public void setSonargraphBuildVersion(String sonargraphBuildVersion) {
        this.sonargraphBuildVersion = sonargraphBuildVersion;
    }

    @DataBoundSetter
    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    @DataBoundSetter
    public void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }

    @DataBoundSetter
    public void setWorkspaceProfile(String workspaceProfile) {
        this.workspaceProfile = workspaceProfile;
    }

    @DataBoundSetter
    public void setSnapshotDirectory(String snapshotDirectory) {
        this.snapshotDirectory = snapshotDirectory;
    }

    @DataBoundSetter
    public void setSnapshotFileName(String snapshotFileName) {
        this.snapshotFileName = snapshotFileName;
    }

    @DataBoundSetter
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @DataBoundSetter
    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (JobCategory.isRelevantProject(project)) {
            ResultWithOutcome<MetricIds> result = MetricIdProvider.getMetricIds(project);
            if (result.isSuccess()) {
                ArrayList<String> metricList = new ArrayList<String>();
                MetricIds exportMetaData = (MetricIds)result.getOutcome();
                if (this.isAllCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds().keySet());
                } else if (this.isJavaCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("JavaLanguageProvider").keySet());
                } else if (this.isCplusplusCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("CPlusPlusLanguageProvider").keySet());
                } else if (this.isCsharpCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("CSharpLanguageProvider").keySet());
                } else if (this.isPythonCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("PythonLanguageProvider").keySet());
                } else if (this.metrics != null) {
                    for (Metric metric : this.metrics) {
                        metricList.add(metric.getMetricName());
                    }
                }
                actions.add((Action)new SonargraphIntegrationAction((Job<?, ?>)project, (List<String>)metricList, exportMetaData));
            } else {
                SonargraphLogger.INSTANCE.log(Level.SEVERE, "Cannot add SonargraphChartAction, no Meta Data found.");
            }
            actions.add(new InvisibleReportAction((Job<?, ?>)project));
            actions.add(new InvisibleDiffAction((Job<?, ?>)project));
        }
        return actions;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        super.logExecutionStart(run, listener, SonargraphReportBuilder.class);
        if (this.isSkip()) {
            SonargraphLogger.INSTANCE.log(Level.INFO, "Skipping Sonargraph Build");
            return;
        }
        if (this.isGeneratedBySonargraphBuild() && !this.callSonargraphBuild(run, workspace, launcher, listener)) {
            return;
        }
        FilePath sonargraphReportDirectory = new FilePath(workspace, this.getReportDirectory());
        if (this.processSonargraphReport(run, sonargraphReportDirectory, this.getReportFileName(), listener.getLogger())) {
            run.addAction((Action)new SonargraphBadgeAction());
            run.addAction((Action)new SonargraphReportAction(run));
            if (this.diffReportCreated()) {
                run.addAction((Action)new SonargraphDiffAction(run));
            }
        }
    }

    private boolean callSonargraphBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String baselineReportPath;
        VersionNumber since;
        String host;
        ProxyConfiguration proxyConfig;
        FilePath clientJar;
        SonargraphBuild sonargraphBuild;
        JDK jdk;
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Calling Sonargraph Build.", null);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return false;
        }
        String jdkName = this.getSonargraphBuildJDK();
        if (jdkName == null || jdkName.isEmpty()) {
            List allJDKs = jenkins.getJDKs();
            if (allJDKs.size() == 0) {
                jdk = new JDK("default", System.getProperty("java.home"));
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.WARNING, "Must try to use JDK Jenkins is running with for Sonargraph Build.", null);
            } else if (allJDKs.size() == 1) {
                jdk = (JDK)allJDKs.get(0);
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Using default JDK '" + jdk.getName() + "' for Sonargraph Build.", null);
            } else {
                jdk = (JDK)allJDKs.get(0);
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.WARNING, "There are multiple JDKs, please configure one of them. Using JDK '" + jdk.getName() + "' (the first one) for Sonargraph Build.", null);
            }
        } else {
            jdk = jenkins.getJDK(jdkName);
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Using configured JDK '" + jdkName + "' for Sonargraph Build.", null);
        }
        if (jdk == null) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Unknown JDK '" + jdkName + "' configured for Sonargraph Build.", null);
            return false;
        }
        jdk = jdk.forNode(workspace.toComputer().getNode(), listener);
        FilePath javaDir = new FilePath(launcher.getChannel(), jdk.getHome());
        FilePath javaBinDir = new FilePath(javaDir, "bin");
        FilePath javaExe = new FilePath(javaBinDir, File.separatorChar == '\\' ? "java.exe" : "java");
        SonargraphBuild.DescriptorImpl descriptor = (SonargraphBuild.DescriptorImpl)jenkins.getDescriptorByType(SonargraphBuild.DescriptorImpl.class);
        String version = this.getSonargraphBuildVersion();
        if (version == null || version.isEmpty()) {
            SonargraphBuild[] allSonargraphBuildInstallations = (SonargraphBuild[])descriptor.getInstallations();
            if (allSonargraphBuildInstallations.length != 1) {
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Sonargraph Build not configured.", null);
                return false;
            }
            sonargraphBuild = allSonargraphBuildInstallations[0];
        } else {
            sonargraphBuild = descriptor.getSonargraphBuild(version);
        }
        if (sonargraphBuild == null) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Unknown Sonargraph Build configured.", null);
            return false;
        }
        Computer computer = workspace.toComputer();
        assert (computer != null) : "Workspace " + String.valueOf(workspace) + " is not connected to any computer.";
        Node node = computer.getNode();
        assert (node != null) : "Workspace " + String.valueOf(workspace) + " is not connected to any node.";
        sonargraphBuild = sonargraphBuild.forNode(node, listener);
        FilePath installationDirectory = new FilePath(launcher.getChannel(), sonargraphBuild.getHome());
        FilePath pluginsDirectory = new FilePath(installationDirectory, "plugins");
        FilePath clientDirectory = new FilePath(installationDirectory, "client");
        FilePath[] osgiJars = pluginsDirectory.list(ORG_ECLIPSE_OSGI_JAR);
        FilePath osgiJar = osgiJars.length == 1 ? osgiJars[0] : null;
        FilePath[] clientJars = pluginsDirectory.list(SONARGRAPH_BUILD_CLIENT_JAR);
        FilePath filePath = clientJar = clientJars.length == 1 ? clientJars[0] : null;
        if (clientJar == null) {
            clientJars = clientDirectory.list(SONARGRAPH_BUILD_CLIENT_JAR);
            FilePath filePath2 = clientJar = clientJars.length == 1 ? clientJars[0] : null;
        }
        if (osgiJar == null || clientJar == null) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Missing plugins in Sonargraph Build installation.", null);
            return false;
        }
        VersionNumber clientVersion = SonargraphUtil.getVersionFromJarName(clientJar.getName());
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "SonargraphBuild client jar version is " + String.valueOf(clientVersion), null);
        File configurationFileMaster = File.createTempFile("sonargraphBuildConfigurationMaster", ".xml");
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Writing SonargraphBuild temporary configuration file on master to " + configurationFileMaster.getAbsolutePath(), null);
        ConfigurationFileWriter writer = new ConfigurationFileWriter(configurationFileMaster);
        EnumMap<ConfigurationFileWriter.SonargraphBuildParameter, String> parameters = new EnumMap<ConfigurationFileWriter.SonargraphBuildParameter, String>(ConfigurationFileWriter.SonargraphBuildParameter.class);
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.ACTIVATION_CODE, this.getActivationCode());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.INSTALLATION_DIRECTORY, sonargraphBuild.getHome());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.LANGUAGES, SonargraphReportBuilder.getLanguages(this.languageJava, this.languageCPlusPlus, this.languageCSharp, this.languagePython));
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.SYSTEM_DIRECTORY, this.getSystemDirectory());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.REPORT_DIRECTORY, this.getReportDirectory());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.REPORT_FILENAME, this.getReportFileName());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.REPORT_TYPE, this.getReportType());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.REPORT_FORMAT, this.getReportFormat());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.QUALITY_MODEL_FILE, this.getQualityModelFile());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.VIRTUAL_MODEL, this.getVirtualModel());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.LICENSE_FILE, this.getLicenseFile());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.LICENSE_SERVER_HOST, this.getDescriptor().getLicenseServerHost());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.LICENSE_SERVER_PORT, this.getDescriptor().getLicenseServerPort());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.WORKSPACE_PROFILE, this.getWorkspaceProfile());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.SNAPSHOT_DIRECTORY, this.getSnapshotDirectory());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.SNAPSHOT_FILE_NAME, this.getSnapshotFileName());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.LOG_LEVEL, this.getLogLevel());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.LOG_FILE, this.getLogFile());
        parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.ELEMENT_COUNT_TO_SPLIT_HTML_REPORT, DO_NOT_SPLIT);
        if (this.isUseHttpProxy() && (proxyConfig = ProxyConfiguration.load()) != null && (host = proxyConfig.getName()) != null && !host.isEmpty()) {
            int port = proxyConfig.getPort();
            parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.PROXY_HOST, host);
            parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.PROXY_PORT, String.valueOf(port));
            String username = proxyConfig.getUserName();
            if (username != null && !username.isEmpty()) {
                parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.PROXY_USERNAME, username);
                Secret secretPassword = proxyConfig.getSecretPassword();
                if (secretPassword != null) {
                    String password = Secret.toString((Secret)secretPassword);
                    parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.PROXY_PASSWORD, password);
                }
            }
        }
        if (clientVersion.isNewerThan(since = new VersionNumber("9.12"))) {
            parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.PROGRESS_INFO, "basic");
        }
        if (clientVersion.isNewerThan(since = new VersionNumber("9.13")) && (baselineReportPath = this.getBaselineReportPath()) != null && !baselineReportPath.isEmpty()) {
            parameters.put(ConfigurationFileWriter.SonargraphBuildParameter.REPORT_BASELINE, this.getBaselineReportPath() + ".xml");
        }
        writer.createConfigurationFile(parameters, listener.getLogger());
        String content = new FilePath(configurationFileMaster).readToString();
        FilePath configurationFileSlave = javaDir.createTextTempFile("sonargraphBuildConfigurationSlave", ".xml", content, false);
        String classpathSeparator = launcher.isUnix() ? ":" : ";";
        String sonargraphBuildCommand = this.handleBlanksForConsoleCommand(javaExe.getRemote()) + " -ea -cp " + this.handleBlanksForConsoleCommand(clientJar.getRemote()) + classpathSeparator + this.handleBlanksForConsoleCommand(osgiJar.getRemote()) + " com.hello2morrow.sonargraph.build.client.SonargraphBuildRunner " + configurationFileSlave.getRemote();
        Launcher.ProcStarter procStarter = new Launcher.ProcStarter(launcher);
        procStarter.cmdAsSingleString(sonargraphBuildCommand);
        procStarter.stdout((OutputStream)listener.getLogger());
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Setting working directory for Sonargraph Build to " + String.valueOf(workspace), null);
        procStarter = procStarter.pwd(workspace);
        Proc proc = launcher.launch(procStarter);
        int processExitCode = proc.join();
        if (processExitCode != 0) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "There was an error when executing Sonargraph Build. Check the global configuration parameters and the relative paths to make sure that everything is in place.", null);
            return false;
        }
        return true;
    }

    private String handleBlanksForConsoleCommand(String partOfCommand) {
        if (partOfCommand.contains(" ")) {
            return "\"" + partOfCommand + "\"";
        }
        return partOfCommand;
    }

    private String getReportType() {
        return "standard";
    }

    @Override
    public String getReportPath() {
        if (this.isGeneratedBySonargraphBuild()) {
            return ConfigParameters.SONARGRAPH_REPORT_TARGET_DIRECTORY.getValue() + ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue();
        }
        return this.reportPath;
    }

    public String getBaselineReportPath() {
        return this.baselineReportPath;
    }

    public boolean diffReportCreated() {
        return this.getBaselineReportPath() != null && !this.getBaselineReportPath().isEmpty();
    }

    public String getMetaDataFile() {
        return this.metaDataFile;
    }

    public boolean getLanguageJava() {
        return this.languageJava;
    }

    public boolean getLanguageCSharp() {
        return this.languageCSharp;
    }

    public boolean getLanguageCPlusPlus() {
        return this.languageCPlusPlus;
    }

    public boolean getLanguagePython() {
        return this.languagePython;
    }

    protected static String getLanguages(boolean languageJava, boolean languageCPlusPlus, boolean languageCSharp, boolean languagePython) {
        boolean allLanguages = !languageJava && !languageCPlusPlus && !languageCSharp && !languagePython;
        ArrayList<String> languages = new ArrayList<String>();
        if (allLanguages || languageJava) {
            languages.add("Java");
        }
        if (allLanguages || languageCPlusPlus) {
            languages.add("CPlusPlus");
        }
        if (allLanguages || languageCSharp) {
            languages.add("CSharp");
        }
        if (allLanguages || languagePython) {
            languages.add("Python");
        }
        return languages.stream().collect(Collectors.joining(","));
    }

    public String getSonargraphBuildJDK() {
        return this.sonargraphBuildJDK;
    }

    public String getSonargraphBuildVersion() {
        return this.sonargraphBuildVersion;
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public String getWorkspaceProfile() {
        return this.workspaceProfile;
    }

    public String getSnapshotDirectory() {
        return this.snapshotDirectory;
    }

    public String getSnapshotFileName() {
        return this.snapshotFileName;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogFile() {
        return this.logFile;
    }

    private String getReportFileName() {
        if (this.isGeneratedBySonargraphBuild()) {
            return ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue();
        }
        return new File(this.getReportPath()).getName();
    }

    @Override
    public String getReportDirectory() {
        if (this.isGeneratedBySonargraphBuild()) {
            return ConfigParameters.SONARGRAPH_REPORT_TARGET_DIRECTORY.getValue();
        }
        return new File(this.getReportPath()).getParent();
    }

    private String getReportFormat() {
        return "xml,html";
    }

    public String getSystemDirectory() {
        return this.systemDirectory;
    }

    public String getReportGeneration() {
        return this.reportGeneration;
    }

    public String getChartConfiguration() {
        return this.chartConfiguration;
    }

    public String getQualityModelFile() {
        return this.qualityModelFile;
    }

    public String getVirtualModel() {
        return this.virtualModel;
    }

    public boolean isGeneratedBySonargraphBuild() {
        return !this.isPreGenerated();
    }

    public boolean isPreGenerated() {
        return "preGenerated".equals(this.getReportGeneration());
    }

    public boolean isAllCharts() {
        return "allCharts".equals(this.getChartConfiguration());
    }

    public boolean isJavaCharts() {
        return "javaCharts".equals(this.getChartConfiguration());
    }

    public boolean isCplusplusCharts() {
        return "cplusplusCharts".equals(this.getChartConfiguration());
    }

    public boolean isCsharpCharts() {
        return "csharpCharts".equals(this.getChartConfiguration());
    }

    public boolean isPythonCharts() {
        return "pythonCharts".equals(this.getChartConfiguration());
    }

    public boolean isSelectedCharts() {
        return "selectedCharts".equals(this.getChartConfiguration());
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isUseHttpProxy() {
        return this.useHttpProxy;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static boolean validateNotNullAndRegexp(String value, String pattern) {
        if (value == null) {
            return false;
        }
        return value.matches(pattern);
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_INTEGRATION.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_INTEGRATION.getValue();
    }

    public Collection<? extends Action> getProjectActions() {
        System.out.println("Class of project: " + String.valueOf(this.run.getClass()));
        return this.getProjectActions((AbstractProject)this.run.getParent());
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    @Extension
    @Symbol(value={"SonargraphReport"})
    public static final class DescriptorImpl
    extends AbstractBuildStepDescriptor {
        static final List<String> DEFAULT_QUALITY_MODELS = Arrays.asList("Sonargraph:Default.sgqm", "Sonargraph:Java.sgqm", "Sonargraph:CSharp.sgqm", "Sonargraph:CPlusPlus.sgqm");
        static final List<String> LOG_LEVELS = Arrays.asList("info", "off", "error", "warn", "debug", "trace", "all");
        public static final String DEFAULT_VIRTUAL_MODEL = "Modifiable.vm";
        public static final String DEFAULT_LOG_FILE = "sonargraph_build.log";
        public static final String DEFAULT_LOG_LEVEL = "info";
        public static final String DEFAULT_REPORT_PATH = "./target/sonargraph/sonargraph-report";
        public static final String DEFAULT_REPORT_GENERATION = "generatedBySonargraphBuild";
        public static final String DEFAULT_CHART_CONFIGURATION = "allCharts";
        private String licenseServerHost;
        private String licenseServerPort;

        public DescriptorImpl() {
            this.load();
        }

        public String getLicenseServerHost() {
            return this.licenseServerHost;
        }

        public String getLicenseServerPort() {
            return this.licenseServerPort;
        }

        public void setLicenseServerHost(String licenseServerHost) {
            this.licenseServerHost = licenseServerHost;
            SonargraphLogger.INSTANCE.log(Level.INFO, "License Server Host is " + licenseServerHost);
        }

        public void setLicenseServerPort(String licenseServerPort) {
            this.licenseServerPort = licenseServerPort;
            SonargraphLogger.INSTANCE.log(Level.INFO, "License Server Port is " + licenseServerPort);
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            json = json.getJSONObject("sonargraph");
            this.setLicenseServerHost(json.getString("licenseServerHost"));
            this.setLicenseServerPort(json.getString("licenseServerPort"));
            this.save();
            return true;
        }

        public String getDisplayName() {
            return ConfigParameters.REPORT_BUILDER_DISPLAY_NAME.getValue();
        }

        public ListBoxModel doFillSonargraphBuildJDKItems() {
            ListBoxModel items = new ListBoxModel();
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return items;
            }
            for (JDK jdk : jenkins.getJDKs()) {
                items.add(jdk.getName(), jdk.getName());
            }
            return items;
        }

        public ListBoxModel doFillSonargraphBuildVersionItems() {
            ListBoxModel items = new ListBoxModel();
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return items;
            }
            SonargraphBuild.DescriptorImpl descriptor = (SonargraphBuild.DescriptorImpl)jenkins.getDescriptorByType(SonargraphBuild.DescriptorImpl.class);
            for (SonargraphBuild sonargraphBuild : (SonargraphBuild[])descriptor.getInstallations()) {
                items.add(sonargraphBuild.getName(), sonargraphBuild.getName());
            }
            return items;
        }

        public ListBoxModel doFillMetricCategoryItems(@AncestorInPath AbstractProject<?, ?> project) {
            ListBoxModel items = new ListBoxModel();
            ResultWithOutcome<MetricIds> result = MetricIdProvider.getMetricIds(project);
            if (result.isSuccess()) {
                MetricIds metaData = (MetricIds)result.getOutcome();
                metaData.getMetricCategories().stream().sorted().forEachOrdered(category -> items.add(category, category));
            }
            return items;
        }

        public ListBoxModel doFillMetricNameItems(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String metricCategory, @QueryParameter(value="metaDataFile") @RelativePath(value="..") String metaDataFile) {
            if (metricCategory == null || metricCategory.isEmpty()) {
                SonargraphLogger.INSTANCE.log(Level.WARNING, "metric category is unset, assume 'Architecture'");
                metricCategory = "Architecture";
            }
            ListBoxModel items = new ListBoxModel();
            ResultWithOutcome<MetricIds> result = MetricIdProvider.getMetricIds(project);
            if (result.isSuccess()) {
                MetricIds metaData = (MetricIds)result.getOutcome();
                for (MetricId metric : metaData.getMetricIdsForCategory(metricCategory)) {
                    items.add(metric.getName(), metric.getId());
                }
            }
            return items;
        }

        public ComboBoxModel doFillQualityModelFileItems() {
            return new ComboBoxModel(DEFAULT_QUALITY_MODELS);
        }

        public FormValidation doCheckLicenseFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            return this.checkAbsoluteFile(value, "license");
        }

        public FormValidation doCheckLicenseServerPort(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int parsed = Integer.parseUnsignedInt(value);
                if (parsed > 0 && parsed <= 65535) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Please enter a valid port number.");
        }

        public FormValidation doCheckLogFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (project != null && (value == null || value.isEmpty())) {
                return FormValidation.error((String)"Path of log file must be specified.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQualityModelFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (DEFAULT_QUALITY_MODELS.contains(value)) {
                return FormValidation.ok();
            }
            return this.checkFileInWorkspace(project, value, "sgqm");
        }

        public FormValidation doCheckReportPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (value != null && !value.isEmpty()) {
                File withParent = new File(value);
                File parent = withParent.getParentFile();
                if (parent == null) {
                    return FormValidation.error((String)"Please enter a path with at least one directory.");
                }
                if (value.endsWith(".xml")) {
                    return FormValidation.error((String)"Please enter a path without extension \".xml\".");
                }
            }
            return this.checkFileInWorkspace(project, value + ".xml", null);
        }

        public FormValidation doCheckBaselineReportPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (value != null && !value.isEmpty()) {
                if (value.endsWith(".xml")) {
                    return FormValidation.error((String)"Please enter a path without extension \".xml\".");
                }
                return this.checkFileInWorkspace(project, value + ".xml", null);
            }
            return FormValidation.ok();
        }

        private FormValidation checkFileInWorkspace(AbstractProject<?, ?> project, String file, String extension) throws IOException {
            if (project == null) {
                return FormValidation.ok();
            }
            if (file != null && !file.isEmpty()) {
                if (extension != null && !extension.isEmpty() && !file.endsWith(extension)) {
                    return FormValidation.error((String)("Please enter a valid filename. Extension must be '" + extension + "'."));
                }
                FilePath ws = project.getSomeWorkspace();
                if (ws == null) {
                    return FormValidation.error((String)"Please run build at least once to get a workspace.");
                }
                FormValidation validateRelativePath = ws.validateRelativePath(file, true, true);
                if (validateRelativePath.kind != FormValidation.Kind.OK) {
                    return validateRelativePath;
                }
            }
            return FormValidation.ok();
        }

        private FormValidation checkAbsoluteFile(String file, String extension) {
            if (file != null && !file.isEmpty()) {
                if (extension != null && !extension.isEmpty() && !file.endsWith(extension)) {
                    return FormValidation.error((String)("Please enter a valid filename. Extension must be '" + extension + "'."));
                }
                File f = new File(file);
                if (!f.exists()) {
                    return FormValidation.error((String)"Please enter an existing file.");
                }
                if (!f.canRead()) {
                    return FormValidation.error((String)"Please enter a readable file.");
                }
                if (!f.isAbsolute()) {
                    return FormValidation.error((String)"Please enter an absolute file path.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSystemDirectory(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (value == null || value.length() == 0) {
                return FormValidation.ok();
            }
            if (!SonargraphReportBuilder.validateNotNullAndRegexp(value, "([a-zA-Z]:\\\\)?[\\/\\\\a-zA-Z0-9_.-]+.sonargraph$")) {
                return FormValidation.error((String)"Please enter a valid system directory");
            }
            if (project == null) {
                return FormValidation.ok();
            }
            FilePath ws = project.getSomeWorkspace();
            if (ws == null) {
                return FormValidation.error((String)"Please run build at least once to get a workspace.");
            }
            return ws.validateRelativeDirectory(value, true);
        }

        public ListBoxModel doFillLogLevelItems() {
            ListBoxModel items = new ListBoxModel();
            LOG_LEVELS.forEach(level -> items.add(level));
            return items;
        }
    }
}

