/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.jenkins.controller.BuildActionsEnum;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.CSVFileHandler;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIdsHistory;
import hudson.FilePath;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.jenkinsci.remoting.RoleChecker;

class SonargraphBuildAnalyzer {
    private final HashMap<String, Result> m_buildResults = new HashMap();
    private Result m_overallBuildResult;
    private PrintStream m_logger = null;
    private final ISonargraphSystemController m_controller = ControllerFactory.createController();

    public SonargraphBuildAnalyzer(FilePath sonargraphReportPath, PrintStream logger) throws IOException, InterruptedException {
        assert (sonargraphReportPath != null) : "The path for the Sonargraph architect report must not be null";
        assert (logger != null) : "Parameter 'logger' of method 'SonargraphBuildAnalyzer' mu st not be null";
        this.m_logger = logger;
        com.hello2morrow.sonargraph.integration.access.foundation.Result operationResult = (com.hello2morrow.sonargraph.integration.access.foundation.Result)sonargraphReportPath.act((FilePath.FileCallable)new LoadSystemReport(this.m_controller));
        if (operationResult.isFailure()) {
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.SEVERE, "Failed to load report from '" + String.valueOf(sonargraphReportPath) + "': " + operationResult.toString(), null);
        }
        this.m_buildResults.put(BuildActionsEnum.UNSTABLE.getActionCode(), Result.UNSTABLE);
        this.m_buildResults.put(BuildActionsEnum.FAILED.getActionCode(), Result.FAILURE);
        this.m_overallBuildResult = null;
    }

    public Result changeBuildResultIfViolationThresholdsExceeded(Integer thresholdUnstable, Integer thresholdFailed) {
        Predicate<IIssue> filter;
        if (!this.m_controller.hasSoftwareSystem()) {
            return null;
        }
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        Integer numberOfViolations = infoProcessor.getIssues(filter = issue -> issue.getIssueType().getCategory().getName().equals("ArchitectureViolation") && !issue.hasResolution()).size();
        if (numberOfViolations > 0) {
            if (numberOfViolations >= thresholdFailed) {
                return this.m_buildResults.get(BuildActionsEnum.FAILED.getActionCode());
            }
            if (numberOfViolations >= thresholdUnstable && numberOfViolations < thresholdFailed) {
                return this.m_buildResults.get(BuildActionsEnum.UNSTABLE.getActionCode());
            }
        }
        return null;
    }

    public void changeBuildResultIfIssuesExist(String issueCategory, Severity minimumSeverity, String userDefinedAction) {
        Predicate<IIssue> filter;
        if (!this.m_controller.hasSoftwareSystem()) {
            return;
        }
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        int numberOfIssues = infoProcessor.getIssues(filter = issue -> issue.getIssueType().getCategory().getName().equals(issueCategory) && issue.getSeverity().ordinal() <= minimumSeverity.ordinal() && !issue.hasResolution()).size();
        if (numberOfIssues <= 0) {
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.FINE, "Not changing build result because number of '" + issueCategory + "' is " + numberOfIssues, null);
            return;
        }
        if (BuildActionsEnum.FAILED.getActionCode().equals(userDefinedAction)) {
            this.m_overallBuildResult = this.m_buildResults.get(BuildActionsEnum.FAILED.getActionCode());
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Changing build result to " + this.m_overallBuildResult.toString() + " because value for '" + issueCategory + "' is " + numberOfIssues, null);
        } else if (BuildActionsEnum.UNSTABLE.getActionCode().equals(userDefinedAction) && (this.m_overallBuildResult == null || !this.m_overallBuildResult.equals(Result.FAILURE))) {
            this.m_overallBuildResult = this.m_buildResults.get(BuildActionsEnum.UNSTABLE.getActionCode());
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Changing build result to " + this.m_overallBuildResult.toString() + " because value for '" + issueCategory + "' is " + numberOfIssues, null);
        }
    }

    public void changeBuildResultIfMetricValueNotZero(String metricName, String userDefinedAction) {
        if (!this.m_controller.hasSoftwareSystem()) {
            return;
        }
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        Optional metricValue = infoProcessor.getMetricValue(metricName);
        if (!metricValue.isPresent()) {
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.WARNING, "Metric '" + metricName + "' not present in analysis", null);
            return;
        }
        int value = ((IMetricValue)metricValue.get()).getValue().intValue();
        if (value <= 0) {
            return;
        }
        if (userDefinedAction.equals(BuildActionsEnum.FAILED.getActionCode())) {
            this.m_overallBuildResult = this.m_buildResults.get(BuildActionsEnum.FAILED.getActionCode());
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Changing build result to " + this.m_overallBuildResult.toString() + " because value for '" + ((IMetricValue)metricValue.get()).getId().getPresentationName() + "' is " + value, null);
        } else if (userDefinedAction.equals(BuildActionsEnum.UNSTABLE.getActionCode()) && (this.m_overallBuildResult == null || !this.m_overallBuildResult.equals(Result.FAILURE))) {
            this.m_overallBuildResult = this.m_buildResults.get(BuildActionsEnum.UNSTABLE.getActionCode());
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Changing build result to " + this.m_overallBuildResult.toString() + " because value for '" + ((IMetricValue)metricValue.get()).getId().getPresentationName() + "' is " + value, null);
        }
    }

    public void changeBuildResultIfMetricValueIsZero(String metricName, String userDefinedAction) {
        if (!this.m_controller.hasSoftwareSystem()) {
            return;
        }
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        Optional metricValue = infoProcessor.getMetricValue(metricName);
        if (!metricValue.isPresent()) {
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.WARNING, "Metric '" + metricName + "' not present in analysis", null);
            return;
        }
        int value = ((IMetricValue)metricValue.get()).getValue().intValue();
        if (value == 0) {
            if (userDefinedAction.equals(BuildActionsEnum.FAILED.getActionCode())) {
                this.m_overallBuildResult = this.m_buildResults.get(BuildActionsEnum.FAILED.getActionCode());
                SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Changing build result to " + this.m_overallBuildResult.toString() + " because value for " + ((IMetricValue)metricValue.get()).getId().getName() + " is " + value, null);
            } else if (userDefinedAction.equals(BuildActionsEnum.UNSTABLE.getActionCode()) && (this.m_overallBuildResult == null || !this.m_overallBuildResult.equals(Result.FAILURE))) {
                this.m_overallBuildResult = this.m_buildResults.get(BuildActionsEnum.UNSTABLE.getActionCode());
                SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Changing build result to " + this.m_overallBuildResult.toString() + " because value for " + ((IMetricValue)metricValue.get()).getId().getName() + " is " + value, null);
            }
        } else {
            SonargraphLogger.logToConsoleOutput(this.m_logger, Level.FINE, "Not changing build result because value for '" + ((IMetricValue)metricValue.get()).getId().getName() + "' is " + value, null);
        }
    }

    public void saveMetrics(File metricHistoryFile, File metricIdsHistoryFile, long timeOfBuild, Integer buildNumber) throws IOException {
        SonargraphLogger.logToConsoleOutput(this.m_logger, Level.INFO, "Save metrics to history", null);
        if (!this.m_controller.hasSoftwareSystem()) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Software System expected");
            return;
        }
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        MetricIdsHistory metricIdsHistory = new MetricIdsHistory(metricIdsHistoryFile);
        MetricIds metricIds = metricIdsHistory.addMetricIds(MetricIds.fromIMetricIds(infoProcessor.getMetricIds()), this.m_logger);
        CSVFileHandler metricHistory = new CSVFileHandler(metricHistoryFile, metricIds);
        HashMap<MetricId, String> buildMetricValues = new HashMap<MetricId, String>();
        for (IMetricId metric : infoProcessor.getMetricIds()) {
            Optional systemMetricValue = infoProcessor.getMetricValue(metric.getName());
            if (!systemMetricValue.isPresent()) continue;
            buildMetricValues.put(MetricId.from(metric), ((IMetricValue)systemMetricValue.get()).getValue().toString());
        }
        metricHistory.writeMetricValues(buildNumber, timeOfBuild, buildMetricValues);
    }

    public Result getOverallBuildResult() {
        return this.m_overallBuildResult;
    }

    private static final class LoadSystemReport
    implements FilePath.FileCallable<com.hello2morrow.sonargraph.integration.access.foundation.Result> {
        private static final long serialVersionUID = 2405830264590692887L;
        private final ISonargraphSystemController m_controller;

        public LoadSystemReport(ISonargraphSystemController controller) {
            this.m_controller = controller;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }

        public com.hello2morrow.sonargraph.integration.access.foundation.Result invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
            assert (file != null) : "Parameter 'file' in method 'invoke' must not be null";
            SonargraphLogger.INSTANCE.log(Level.INFO, "Load system report from file " + file.getAbsolutePath());
            return this.m_controller.loadSystemReport(file);
        }
    }
}

