/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.LatestFolder;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.TextFileReader;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Job;
import hudson.model.ModelObject;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class PipelineDiffAction
implements Action {
    private final Job<?, ?> job;

    public PipelineDiffAction(Job<?, ?> job) {
        this.job = job;
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_DIFF.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_PIPELINE_DIFF.getValue();
    }

    protected String readHTMLReport(FilePath pathToReport, String alternative) throws IOException, InterruptedException {
        SonargraphLogger.INSTANCE.log(Level.INFO, "Reading Sonargraph HTML Report from '" + String.valueOf(pathToReport) + "'");
        if (pathToReport.exists()) {
            return TextFileReader.readLargeTextFile(pathToReport);
        }
        SonargraphLogger.INSTANCE.log(Level.WARNING, "Unable to read Sonargraph HTML report from '" + String.valueOf(pathToReport) + "'");
        return alternative;
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        File latestFolder = LatestFolder.getFolder(this.getJob());
        this.enableDirectoryBrowserSupport(req, rsp, new FilePath(latestFolder));
    }

    protected void enableDirectoryBrowserSupport(StaplerRequest2 req, StaplerResponse2 rsp, FilePath directoryToServe) throws IOException, ServletException {
        DirectoryBrowserSupport directoryBrowser = new DirectoryBrowserSupport((ModelObject)this, directoryToServe, this.getDisplayName() + "html2", "graph.gif", false);
        SonargraphLogger.INSTANCE.log(Level.FINE, "enableDirectoryBrowserSupport for directory " + directoryToServe.getRemote());
        directoryBrowser.generateResponse(req, rsp, (Object)this);
    }

    public String getHTMLReport() throws IOException, InterruptedException {
        File reportFile = LatestFolder.getDiffReport(this.job);
        return this.readHTMLReport(new FilePath(reportFile), "Unable to read Sonargraph diff report.");
    }

    public boolean isPossible() {
        return LatestFolder.hasDiffReport(this.job);
    }
}

