/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IMetaDataController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricIdsHistoryProvider;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIdsHistory;
import hudson.model.Job;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public class MetricIdProvider {
    private static final String DEFAULT_META_DATA_XML = "MetaData.xml";
    private static IMetricIdsHistoryProvider s_metricIdsHistory;

    public static ResultWithOutcome<MetricIds> getMetricIds(Job<?, ?> project) {
        InputStream is;
        ResultWithOutcome overallResult = new ResultWithOutcome("Get stored MetricIds");
        ResultWithOutcome<MetricIds> historyResult = null;
        if (s_metricIdsHistory == null && project != null) {
            File metricIdsHistoryFile = new File(project.getParent().getRootDir(), ConfigParameters.METRICIDS_HISTORY_JSON_FILE_PATH.getValue());
            s_metricIdsHistory = new MetricIdsHistory(metricIdsHistoryFile);
        }
        if (s_metricIdsHistory != null && (historyResult = s_metricIdsHistory.readMetricIds()).isFailure()) {
            overallResult.addMessagesFrom(historyResult);
            return overallResult;
        }
        IMetaDataController controller = ControllerFactory.createMetaDataController();
        ResultWithOutcome exportMetaDataResult = controller.loadExportMetaData(is = MetricIdProvider.class.getResourceAsStream(DEFAULT_META_DATA_XML), DEFAULT_META_DATA_XML);
        if (exportMetaDataResult.isFailure()) {
            overallResult.addMessagesFrom((Result)exportMetaDataResult);
            return overallResult;
        }
        MetricIds defaultMetricIds = MetricIds.fromExportMetaData((IExportMetaData)exportMetaDataResult.getOutcome());
        if (historyResult != null) {
            MetricIds historyMetricIds = (MetricIds)historyResult.getOutcome();
            overallResult.setOutcome((Serializable)defaultMetricIds.addAll(historyMetricIds));
        } else {
            overallResult.setOutcome((Serializable)defaultMetricIds);
        }
        return overallResult;
    }
}

