/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.action;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.plugins.sonar.action.SonarAnalysisAction;
import hudson.plugins.sonar.client.ProjectInformation;
import hudson.plugins.sonar.client.SQProjectResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SonarCacheAction
extends InvisibleAction {
    private Map<String, ProjectInformation> infoByTaskId = new ConcurrentHashMap<String, ProjectInformation>();
    private Long lastRequest;
    private List<ProjectInformation> lastProjInfo;

    public List<ProjectInformation> get(SQProjectResolver resolver, long lastBuildTime, List<SonarAnalysisAction> analysis, Run<?, ?> run) {
        if (this.lastRequest != null && SonarCacheAction.age(this.lastRequest) < TimeUnit.SECONDS.toMillis(30L)) {
            return this.lastProjInfo;
        }
        ArrayList<ProjectInformation> list = new ArrayList<ProjectInformation>(analysis.size());
        for (SonarAnalysisAction a : analysis) {
            ProjectInformation proj = this.get(resolver, lastBuildTime, a, run);
            if (proj == null) continue;
            list.add(proj);
        }
        this.cacheProjectInfo(list, System.currentTimeMillis());
        return list;
    }

    @CheckForNull
    @VisibleForTesting
    ProjectInformation get(SQProjectResolver resolver, long lastBuildTime, SonarAnalysisAction analysis, Run<?, ?> run) {
        String taskId = analysis.getCeTaskId();
        if (taskId == null) {
            return null;
        }
        ProjectInformation cached = this.infoByTaskId.get(taskId);
        if (SonarCacheAction.isEntryValid(cached, lastBuildTime)) {
            return cached;
        }
        ProjectInformation proj = resolver.resolve(analysis.getInstallationUrl(), analysis.getUrl(), taskId, analysis.getInstallationName(), run);
        if (proj != null) {
            this.infoByTaskId.put(taskId, proj);
        }
        return proj;
    }

    @VisibleForTesting
    static boolean isEntryValid(@Nullable ProjectInformation cached, long lastBuild) {
        long age;
        if (cached == null) {
            return false;
        }
        String status = cached.getCeStatus();
        return status != null ? "failed".equalsIgnoreCase(status) || "success".equalsIgnoreCase(status) || "canceled".equalsIgnoreCase(status) : (age = SonarCacheAction.diff(cached, lastBuild)) > TimeUnit.SECONDS.toMillis(60L);
    }

    @VisibleForTesting
    protected void cacheProjectInfo(List<ProjectInformation> list, Long time) {
        this.lastProjInfo = list;
        this.lastRequest = time;
    }

    private static long age(long time) {
        return System.currentTimeMillis() - time;
    }

    private static long diff(ProjectInformation proj, long lastBuild) {
        return proj.created() - lastBuild;
    }
}

