/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;

class GlobalCredentialMigrator {
    private static final Logger LOGGER = Logger.getLogger(GlobalCredentialMigrator.class.getName());

    GlobalCredentialMigrator() {
    }

    StandardCredentials migrate(@NonNull String token) {
        LOGGER.info("Migrating SonarQube credential: moving authentication token into a credential");
        List allStringCredentials = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstanceOrNull(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null}), (CredentialsMatcher)CredentialsMatchers.always());
        return (StandardCredentials)allStringCredentials.stream().filter(cred -> Optional.ofNullable(cred).map(StringCredentials::getSecret).map(Secret::getPlainText).filter(token::equals).isPresent()).findAny().orElseGet(() -> GlobalCredentialMigrator.addCredentialIfNotPresent(token));
    }

    private static StringCredentials addCredentialIfNotPresent(@NonNull String token) {
        StringCredentialsImpl credentials = new StringCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), "Migrated SonarQube authentication token", Secret.fromString((String)token));
        SystemCredentialsProvider instance = SystemCredentialsProvider.getInstance();
        instance.getCredentials().add(credentials);
        try {
            instance.save();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return credentials;
    }
}

