/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.sonar.api;

import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.sonar.api.ApiConnectionException;
import org.quality.gates.sonar.api.SonarHttpRequester;
import org.quality.gates.sonar.api.UnsuportedVersionException;
import org.quality.gates.sonar.api80.SonarHttpRequester80;
import org.quality.gates.sonar.api88.SonarHttpRequester88;

class SonarHttpRequesterFactory {
    private static final String SONAR_API_SERVER_VERSION = "/api/server/version";

    SonarHttpRequesterFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SonarHttpRequester getSonarHttpRequester(SonarInstance sonarInstance) {
        HttpGet request = new HttpGet(SonarHttpRequesterFactory.getSonarApiServerVersion(sonarInstance));
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            String sonarVersion = (String)client.execute((ClassicHttpRequest)request, classicHttpResponse -> EntityUtils.toString((HttpEntity)classicHttpResponse.getEntity()));
            if (SonarHttpRequesterFactory.majorSonarVersion(sonarVersion) == 8 && SonarHttpRequesterFactory.minorSonarVersion(sonarVersion) <= 7) {
                SonarHttpRequester80 sonarHttpRequester80 = new SonarHttpRequester80();
                return sonarHttpRequester80;
            }
            if (SonarHttpRequesterFactory.majorSonarVersion(sonarVersion) < 8) throw new UnsuportedVersionException("Plugin doesn't support this version of sonar api!");
            SonarHttpRequester88 sonarHttpRequester88 = new SonarHttpRequester88();
            return sonarHttpRequester88;
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getLocalizedMessage(), e);
        }
    }

    private static String getSonarApiServerVersion(SonarInstance sonarInstance) {
        return sonarInstance.getUrl() + SONAR_API_SERVER_VERSION;
    }

    private static int majorSonarVersion(String sonarVersion) {
        return Integer.parseInt(sonarVersion.split("\\.")[0]);
    }

    private static int minorSonarVersion(String sonarVersion) {
        return Integer.parseInt(sonarVersion.split("\\.")[1]);
    }
}

