/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.quality.gates.jenkins.plugin.GlobalSonarQualityGatesConfiguration;
import org.quality.gates.jenkins.plugin.JobConfigData;
import org.quality.gates.jenkins.plugin.QGException;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.jenkins.plugin.enumeration.BuildStatusEnum;

public class JobConfigurationService {
    private static final Pattern ENV_VARIABLE_WITH_BRACES_PATTERN = Pattern.compile("(\\$\\{[a-zA-Z0-9_]+\\})");
    private static final Pattern ENV_VARIABLE_WITHOUT_BRACES_PATTERN = Pattern.compile("(\\$[a-zA-Z0-9_]+)");

    public ListBoxModel getListOfSonarInstanceNames(GlobalSonarQualityGatesConfiguration globalConfig) {
        ListBoxModel listBoxModel = new ListBoxModel();
        for (SonarInstance sonarInstance : globalConfig.fetchSonarInstances()) {
            listBoxModel.add(sonarInstance.getName());
        }
        return listBoxModel;
    }

    public JobConfigData createJobConfigData(JSONObject formData, GlobalSonarQualityGatesConfiguration globalConfig) {
        JobConfigData firstInstanceJobConfigData = new JobConfigData();
        String projectKey = formData.getString("projectKey");
        if (!projectKey.startsWith("$")) {
            projectKey = URLDecoder.decode(projectKey, StandardCharsets.UTF_8);
        }
        String name = "";
        if (!globalConfig.fetchSonarInstances().isEmpty()) {
            name = this.hasFormDataKey(formData, globalConfig);
        }
        firstInstanceJobConfigData.setProjectKey(projectKey);
        firstInstanceJobConfigData.setSonarInstanceName(name);
        firstInstanceJobConfigData.setBuildStatus(BuildStatusEnum.valueOf(formData.getString("buildStatus")));
        return firstInstanceJobConfigData;
    }

    protected String hasFormDataKey(JSONObject formData, GlobalSonarQualityGatesConfiguration globalConfig) {
        if (formData.containsKey((Object)"sonarInstancesName")) {
            return formData.getString("sonarInstancesName");
        }
        return globalConfig.fetchSonarInstances().get(0).getName();
    }

    public JobConfigData checkProjectKeyIfVariable(JobConfigData jobConfigData, AbstractBuild build, BuildListener listener) throws QGException {
        String projectKey = jobConfigData.getProjectKey();
        if (projectKey.isEmpty()) {
            throw new QGException("Empty project key.");
        }
        JobConfigData envVariableJobConfigData = new JobConfigData();
        envVariableJobConfigData.setSonarInstanceName(jobConfigData.getSonarInstanceName());
        try {
            envVariableJobConfigData.setProjectKey(this.getProjectKey(projectKey, build.getEnvironment((TaskListener)listener)));
        }
        catch (IOException | InterruptedException e) {
            throw new QGException(e);
        }
        envVariableJobConfigData.setSonarInstanceName(jobConfigData.getSonarInstanceName());
        envVariableJobConfigData.setBuildStatus(jobConfigData.getBuildStatus());
        return envVariableJobConfigData;
    }

    private String getProjectKey(String projectKey, EnvVars env) {
        String projectKeyAfterFirstResolving = this.resolveEmbeddedEnvVariables(projectKey, env, ENV_VARIABLE_WITH_BRACES_PATTERN, 1);
        return this.resolveEmbeddedEnvVariables(projectKeyAfterFirstResolving, env, ENV_VARIABLE_WITHOUT_BRACES_PATTERN, 0);
    }

    private String resolveEmbeddedEnvVariables(String projectKey, EnvVars env, Pattern pattern, int braceOffset) {
        Matcher matcher = pattern.matcher(projectKey);
        StringBuilder builder = new StringBuilder(projectKey);
        boolean matchesFound = false;
        int offset = 0;
        while (matcher.find()) {
            String envVariable = projectKey.substring(matcher.start() + braceOffset + 1, matcher.end() - braceOffset);
            String envValue = (String)env.get((Object)envVariable);
            if (envValue == null) {
                throw new QGException("Environment Variable [" + envVariable + "] not found");
            }
            builder.replace(matcher.start() + offset, matcher.end() + offset, envValue);
            offset += envValue.length() - matcher.group(1).length();
            matchesFound = true;
        }
        if (matchesFound) {
            return this.getProjectKey(builder.toString(), env);
        }
        return builder.toString();
    }
}

