/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.quality.gates.jenkins.plugin.GlobalConfigurationService;
import org.quality.gates.jenkins.plugin.SonarInstance;

@Extension
@Symbol(value={"sonarQualityGates"})
public class GlobalSonarQualityGatesConfiguration
extends GlobalConfiguration {
    private List<SonarInstance> sonarInstances;
    private final GlobalConfigurationService globalConfigurationService;

    public GlobalSonarQualityGatesConfiguration() {
        this.load();
        this.globalConfigurationService = new GlobalConfigurationService();
    }

    public GlobalSonarQualityGatesConfiguration(List<SonarInstance> sonarInstances, GlobalConfigurationService globalConfigurationService) {
        this.sonarInstances = sonarInstances;
        this.globalConfigurationService = globalConfigurationService;
    }

    public List<SonarInstance> getSonarInstances() {
        this.load();
        return this.sonarInstances;
    }

    public List<SonarInstance> fetchSonarInstances() {
        return this.sonarInstances;
    }

    @DataBoundSetter
    public void setSonarInstances(List<SonarInstance> globalConfigDataForSonarInstances) {
        this.sonarInstances = globalConfigDataForSonarInstances;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.sonarInstances = this.globalConfigurationService.instantiateGlobalConfigData(json);
        this.save();
        return true;
    }

    public FormValidation doCheckName(@QueryParameter String name) {
        if (name.isEmpty()) {
            return FormValidation.error((String)"Please insert a name for the instance.");
        }
        return FormValidation.ok();
    }

    public SonarInstance getSonarInstanceByName(String name) {
        for (SonarInstance sonarInstance : this.sonarInstances) {
            if (!name.equals(sonarInstance.getName())) continue;
            return sonarInstance;
        }
        return null;
    }
}

