/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import hudson.model.BuildListener;
import org.json.JSONException;
import org.quality.gates.jenkins.plugin.GlobalSonarQualityGatesConfiguration;
import org.quality.gates.jenkins.plugin.JobConfigData;
import org.quality.gates.jenkins.plugin.QGException;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.sonar.api.QualityGatesProvider;

public class BuildDecision {
    private final QualityGatesProvider qualityGatesProvider;

    public BuildDecision(SonarInstance sonarInstance) {
        this.qualityGatesProvider = new QualityGatesProvider(sonarInstance);
    }

    public BuildDecision(QualityGatesProvider qualityGatesProvider) {
        this.qualityGatesProvider = qualityGatesProvider;
    }

    public boolean getStatus(SonarInstance sonarInstance, JobConfigData jobConfigData, BuildListener listener) throws QGException {
        try {
            return this.qualityGatesProvider.getAPIResultsForQualityGates(jobConfigData, sonarInstance, listener).hasStatusGreen();
        }
        catch (InterruptedException | JSONException e) {
            throw new QGException("Please check your credentials or your Project Key", e);
        }
    }

    SonarInstance chooseSonarInstance(GlobalSonarQualityGatesConfiguration globalConfig, JobConfigData jobConfigData) {
        if (globalConfig.fetchSonarInstances().isEmpty()) {
            return this.noSonarInstance(jobConfigData);
        }
        if (globalConfig.fetchSonarInstances().size() == 1) {
            return this.singleSonarInstance(globalConfig, jobConfigData);
        }
        return this.multipleSonarInstances(jobConfigData.getSonarInstanceName(), globalConfig);
    }

    private SonarInstance noSonarInstance(JobConfigData jobConfigData) {
        jobConfigData.setSonarInstanceName("");
        return new SonarInstance();
    }

    private SonarInstance singleSonarInstance(GlobalSonarQualityGatesConfiguration globalConfig, JobConfigData jobConfigData) {
        SonarInstance sonarInstance = globalConfig.fetchSonarInstances().get(0);
        jobConfigData.setSonarInstanceName(sonarInstance.getName());
        return sonarInstance;
    }

    public SonarInstance multipleSonarInstances(String instanceName, GlobalSonarQualityGatesConfiguration globalConfig) {
        return globalConfig.getSonarInstanceByName(instanceName);
    }
}

