/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class UrlBuilder {
    private final List<String> segments = new ArrayList<String>();
    private final Map<String, List<String>> queryParameters = new HashMap<String, List<String>>();

    public UrlBuilder addSegment(String segment) {
        this.segments.add(StringUtils.removeEnd((String)StringUtils.removeStart((String)segment, (String)"/"), (String)"/"));
        return this;
    }

    public UrlBuilder addQueryParameter(String key, String value) {
        this.queryParameters.computeIfAbsent(key, s -> new ArrayList()).add(value);
        return this;
    }

    public String build() {
        String baseUrl = String.join((CharSequence)"/", this.segments);
        if (this.queryParameters.isEmpty()) {
            return baseUrl;
        }
        String queryParams = this.queryParameters.entrySet().stream().flatMap(this::buildQueryParam).collect(Collectors.joining("&"));
        return baseUrl + "?" + queryParams;
    }

    private Stream<String> buildQueryParam(Map.Entry<String, List<String>> entry) {
        return entry.getValue().stream().map(value -> (String)entry.getKey() + "=" + this.urlEncode((String)value));
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

