/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.util;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.BooleanUtils;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritAuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.NotificationConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.ReviewConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.ScoreConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.Inspection;
import org.jenkinsci.plugins.sonargerrit.sonar.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SubJobConfig;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class BackCompatibilityHelper {
    private final SonarToGerritPublisher publisher;
    private final ScoreConfig tempScoreConfig;
    private GerritAuthenticationConfig tempAuthConfig;

    public BackCompatibilityHelper(SonarToGerritPublisher publisher) {
        this.publisher = publisher;
        this.tempScoreConfig = new ScoreConfig();
        this.tempAuthConfig = new GerritAuthenticationConfig();
    }

    public void setSonarURL(String sonarURL) {
        Inspection inspectionConfig = this.getOrCreateInspectionConfig();
        inspectionConfig.setServerURL(sonarURL);
    }

    public void setProjectPath(String path) {
        Inspection inspectionConfig = this.getOrCreateInspectionConfig();
        if (inspectionConfig.getBaseConfig() == null) {
            inspectionConfig.setBaseConfig(new SubJobConfig());
        }
        inspectionConfig.getBaseConfig().setProjectPath(path);
    }

    public void setPath(String path) {
        Inspection inspectionConfig = this.getOrCreateInspectionConfig();
        if (inspectionConfig.getBaseConfig() == null) {
            inspectionConfig.setBaseConfig(new SubJobConfig());
        }
        inspectionConfig.getBaseConfig().setSonarReportPath(path);
    }

    public void setSubJobConfigs(List<SubJobConfig> subJobConfigs) {
        Inspection inspectionConfig = this.getOrCreateInspectionConfig();
        if (subJobConfigs == null || subJobConfigs.isEmpty()) {
            inspectionConfig.setBaseConfig(new SubJobConfig());
            inspectionConfig.setSubJobConfigs(new LinkedList<SubJobConfig>());
        } else if (subJobConfigs.size() == 1) {
            inspectionConfig.setBaseConfig(subJobConfigs.get(0));
            inspectionConfig.setSubJobConfigs(new LinkedList<SubJobConfig>());
        } else {
            inspectionConfig.setBaseConfig(null);
            inspectionConfig.setSubJobConfigs(subJobConfigs);
        }
    }

    public void setPostScore(Boolean postScore) {
        if (BooleanUtils.toBoolean((Boolean)postScore)) {
            if (this.getScoreConfig() == null) {
                this.publisher.setScoreConfig(this.tempScoreConfig);
            }
        } else {
            this.publisher.setScoreConfig(null);
        }
    }

    public void setCategory(String category) {
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        scoreConfig.setCategory(category);
    }

    public void setNoIssuesScore(String score) {
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        try {
            scoreConfig.setNoIssuesScore(Integer.parseInt(score));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setIssuesScore(String score) {
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        try {
            scoreConfig.setIssuesScore(Integer.parseInt(score));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setSeverity(String severity) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        IssueFilterConfig reviewFilterConfig = reviewConfig.getIssueFilterConfig();
        reviewFilterConfig.setSeverity(severity);
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        IssueFilterConfig scoreFilterConfig = scoreConfig.getIssueFilterConfig();
        scoreFilterConfig.setSeverity(severity);
    }

    public void setNewIssuesOnly(Boolean changedLinesOnly) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        IssueFilterConfig reviewFilterConfig = reviewConfig.getIssueFilterConfig();
        reviewFilterConfig.setNewIssuesOnly(changedLinesOnly);
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        IssueFilterConfig scoreFilterConfig = scoreConfig.getIssueFilterConfig();
        scoreFilterConfig.setNewIssuesOnly(changedLinesOnly);
    }

    public void setChangedLinesOnly(Boolean changedLinesOnly) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        IssueFilterConfig reviewFilterConfig = reviewConfig.getIssueFilterConfig();
        reviewFilterConfig.setChangedLinesOnly(changedLinesOnly);
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        IssueFilterConfig scoreFilterConfig = scoreConfig.getIssueFilterConfig();
        scoreFilterConfig.setChangedLinesOnly(changedLinesOnly);
    }

    public void setNoIssuesToPostText(String noIssuesToPost) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        reviewConfig.setNoIssuesTitleTemplate(noIssuesToPost);
    }

    public void setSomeIssuesToPostText(String someIssuesToPost) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        reviewConfig.setSomeIssuesTitleTemplate(someIssuesToPost);
    }

    public void setIssueComment(String issueComment) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        reviewConfig.setIssueCommentTemplate(issueComment);
    }

    public void setOverrideCredentials(Boolean overrideCredentials) {
        if (BooleanUtils.toBoolean((Boolean)overrideCredentials)) {
            if (this.publisher.getAuthConfig() == null) {
                this.publisher.setAuthConfig(this.tempAuthConfig);
            }
        } else {
            this.publisher.setAuthConfig(null);
        }
    }

    public void setHttpUsername(String httpUsername) {
        this.alterAuthenticationConfig(config -> {
            config.setUsername(httpUsername);
            return config;
        });
    }

    public void setHttpPassword(String httpPassword) {
        this.alterAuthenticationConfig(config -> {
            config.setPassword(httpPassword);
            return config;
        });
    }

    public void setNoIssuesNotification(String notification) {
        NotificationConfig notificationConfig = this.getOrCreateNotificationConfig();
        notificationConfig.setNoIssuesNotificationRecipient(notification);
    }

    public void setIssuesNotification(String notification) {
        NotificationConfig notificationConfig = this.getOrCreateNotificationConfig();
        notificationConfig.setCommentedIssuesNotificationRecipient(notification);
    }

    private Inspection getOrCreateInspectionConfig() {
        return this.getInspectionConfig();
    }

    private ReviewConfig getOrCreateReviewConfig() {
        return this.getReviewConfig();
    }

    private NotificationConfig getOrCreateNotificationConfig() {
        return this.getNotificationConfig();
    }

    ScoreConfig getOrCreateScoreConfig() {
        return (ScoreConfig)((Object)MoreObjects.firstNonNull((Object)((Object)this.getScoreConfig()), (Object)((Object)this.tempScoreConfig)));
    }

    private void alterAuthenticationConfig(UnaryOperator<GerritAuthenticationConfig> mutator) {
        boolean tempConfig = false;
        GerritAuthenticationConfig oldConfig = this.publisher.getAuthConfig();
        if (oldConfig == null) {
            tempConfig = true;
            oldConfig = this.tempAuthConfig;
        }
        GerritAuthenticationConfig newConfig = (GerritAuthenticationConfig)((Object)mutator.apply(oldConfig));
        if (tempConfig) {
            this.tempAuthConfig = newConfig;
        } else {
            this.publisher.setAuthConfig(newConfig);
        }
    }

    public String getSonarURL() {
        return null;
    }

    public Collection<SubJobConfig> getSubJobConfigs() {
        return null;
    }

    public String getSeverity() {
        return null;
    }

    public boolean isNewIssuesOnly() {
        return false;
    }

    public boolean isChangedLinesOnly() {
        return false;
    }

    public String getNoIssuesToPostText() {
        return null;
    }

    public String getSomeIssuesToPostText() {
        return null;
    }

    public String getIssueComment() {
        return null;
    }

    public boolean isOverrideCredentials() {
        return false;
    }

    public String getHttpUsername() {
        return null;
    }

    public String getHttpPassword() {
        return null;
    }

    public boolean isPostScore() {
        return false;
    }

    public String getCategory() {
        return null;
    }

    public String getNoIssuesScore() {
        return null;
    }

    public String getIssuesScore() {
        return null;
    }

    public String getNoIssuesNotification() {
        return null;
    }

    public String getIssuesNotification() {
        return null;
    }

    public String getProjectPath() {
        return null;
    }

    public String getPath() {
        return null;
    }

    private Inspection getInspectionConfig() {
        return this.publisher.getInspectionConfig();
    }

    private ReviewConfig getReviewConfig() {
        return this.publisher.getReviewConfig();
    }

    private ScoreConfig getScoreConfig() {
        return this.publisher.getScoreConfig();
    }

    private NotificationConfig getNotificationConfig() {
        return this.publisher.getNotificationConfig();
    }
}

