/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Items;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SubJobConfig
extends AbstractDescribableImpl<SubJobConfig> {
    @Nonnull
    private String projectPath = "";
    @Nonnull
    private String sonarReportPath = "target/sonar/sonar-report.json";
    private boolean autoMatch;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public SubJobConfig(String projectPath, String sonarReportPath) {
        this.setProjectPath(projectPath);
        this.setSonarReportPath(sonarReportPath);
        this.setAutoMatch(false);
    }

    @DataBoundConstructor
    public SubJobConfig() {
        this("", "target/sonar/sonar-report.json");
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getSonarReportPath() {
        return this.sonarReportPath;
    }

    public boolean isAutoMatch() {
        return this.autoMatch;
    }

    @DataBoundSetter
    public void setAutoMatch(boolean autoMatch) {
        this.autoMatch = autoMatch;
    }

    @DataBoundSetter
    public void setProjectPath(String projectPath) {
        this.projectPath = (String)MoreObjects.firstNonNull((Object)projectPath, (Object)"");
    }

    @DataBoundSetter
    public void setSonarReportPath(String sonarReportPath) {
        this.sonarReportPath = (String)MoreObjects.firstNonNull((Object)sonarReportPath, (Object)"target/sonar/sonar-report.json");
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SubJobConfig> {
        public static final String PROJECT_PATH = "";
        public static final String SONAR_REPORT_PATH = "target/sonar/sonar-report.json";

        public String getDisplayName() {
            return "SubJobConfig";
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.sonargerrit.config.SubJobConfig", SubJobConfig.class);
        }
    }
}

