/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.sonargerrit.TaskListenerLogger;
import org.jenkinsci.plugins.sonargerrit.gerrit.Revision;
import org.jenkinsci.plugins.sonargerrit.sonar.Components;
import org.jenkinsci.plugins.sonargerrit.sonar.InspectionReport;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.IssueRepresentation;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.PreviewModeAnalysisStrategy;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.ReportInfo;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.ReportRecorder;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.ReportRepresentation;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SimpleIssue;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarQubeIssueDecorator;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarQubeIssuePathCorrector;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarReportBuilder;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class SonarConnector {
    private static final Logger LOGGER = Logger.getLogger(SonarConnector.class.getName());
    private final TaskListener listener;
    private final PreviewModeAnalysisStrategy strategy;
    private final Revision revision;
    private final SonarInstallation sonarQubeInstallation;

    public SonarConnector(TaskListener listener, PreviewModeAnalysisStrategy strategy, Revision revision, SonarInstallation sonarQubeInstallation) {
        this.listener = listener;
        this.strategy = Objects.requireNonNull(strategy);
        this.revision = revision;
        this.sonarQubeInstallation = sonarQubeInstallation;
    }

    public InspectionReport readSonarReports(FilePath workspace) throws IOException, InterruptedException {
        return this.readSonarReports(workspace, (ReportRecorder)new SimpleReportRecorder());
    }

    public InspectionReport readSonarReports(FilePath workspace, ReportRecorder reportRecorder) throws IOException, InterruptedException {
        ArrayList<ReportInfo> reports = new ArrayList<ReportInfo>();
        for (SubJobConfig subJobConfig : this.strategy.getAllSubJobConfigs()) {
            ReportRepresentation subReport = this.readSonarReport(this.listener, workspace, subJobConfig.getSonarReportPath());
            if (subReport == null) {
                TaskListenerLogger.logMessage(this.listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.path.no.project.config.available", new Object[0]);
                throw new AbortException(Localization.getLocalized("jenkins.plugin.error.path.no.project.config.available"));
            }
            reports.add(new ReportInfo(subJobConfig, subReport));
        }
        this.readSonarReports(reports, reportRecorder);
        return new InspectionReport(reportRecorder.getIssuesList());
    }

    public void readSonarReports(List<ReportInfo> reports, ReportRecorder reportRecorder) {
        reportRecorder.reset();
        reportRecorder.recordReportInfos(reports);
        SonarQubeIssueDecorator decorator = this.strategy.isPathCorrectionNeeded() ? new SonarQubeIssuePathCorrector(this.listener, this.revision) : SonarQubeIssueDecorator.Noop.INSTANCE;
        String sonarQubeUrl = Optional.ofNullable(this.sonarQubeInstallation).map(SonarInstallation::getServerUrl).orElse(null);
        for (ReportInfo info : reports) {
            ReportRepresentation report = info.report;
            Components components = new Components(report.getComponents());
            for (IssueRepresentation issue : report.getIssues()) {
                SimpleIssue issueToRecord = decorator.decorate(new SimpleIssue(issue, components, info.config, sonarQubeUrl));
                reportRecorder.recordIssue(issueToRecord);
            }
        }
    }

    private ReportRepresentation readSonarReport(TaskListener listener, FilePath workspace, String sonarReportPath) throws IOException, InterruptedException {
        FilePath reportPath = workspace.child(sonarReportPath);
        if (!reportPath.exists()) {
            TaskListenerLogger.logMessage(listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.sonar.report.not.exists", reportPath);
            return null;
        }
        if (reportPath.isDirectory()) {
            TaskListenerLogger.logMessage(listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.sonar.report.path.directory", reportPath);
            return null;
        }
        TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.inspection.report.loading", reportPath);
        SonarReportBuilder builder = new SonarReportBuilder();
        String reportJson = reportPath.readToString();
        ReportRepresentation subReport = builder.fromJson(reportJson);
        TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.inspection.report.loaded", subReport.getIssues().size());
        return subReport;
    }

    private static class SimpleReportRecorder
    implements ReportRecorder {
        private final List<Issue> issuesList = new ArrayList<Issue>();

        private SimpleReportRecorder() {
        }

        @Override
        public void reset() {
            this.issuesList.clear();
        }

        @Override
        public void recordReportInfos(List<ReportInfo> reportInfos) {
        }

        @Override
        public void recordIssue(Issue issue) {
            this.issuesList.add(issue);
        }

        @Override
        public List<Issue> getIssuesList() {
            return new ArrayList<Issue>(this.issuesList);
        }
    }
}

