/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.Optional;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public interface Issue {
    public String inspectorName();

    public String inspectionId();

    public Optional<String> detailUrl();

    public String getFilepath();

    public String getKey();

    public String getComponent();

    public Integer getLine();

    public String getMessage();

    public Severity getSeverity();

    public String getRule();

    public String getRuleUrl();

    public String getStatus();

    public boolean isNew();

    public Date getCreationDate();

    public static Multimap<String, Issue> asMultimap(Iterable<Issue> issues) {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        for (Issue issue : issues) {
            multimap.put((Object)issue.getFilepath(), (Object)issue);
        }
        return multimap;
    }
}

