/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.sonargerrit.sonar.Component;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Components {
    private final Map<String, Node> nodes = Maps.newHashMap();

    public Components(List<? extends Component> components) {
        Preconditions.checkNotNull(components);
        for (Component component : components) {
            this.nodes.put(component.getKey(), new Node(component));
        }
    }

    public Optional<String> buildPrefixedPathForComponentWithKey(String componentKey, String prefix) {
        Node n = this.getNodeByComponentKey(componentKey);
        if (n != null) {
            this.connectAncestors(n);
            return Optional.of((Object)n.buildPrefixedPath(Strings.nullToEmpty((String)prefix)));
        }
        return Optional.absent();
    }

    private void connectAncestors(Node n) {
        if (n.isParentConnected()) {
            return;
        }
        Optional<Node> parent = this.findParent(n);
        n.setParent(parent);
        if (parent.isPresent()) {
            this.connectAncestors((Node)parent.get());
        }
    }

    private Optional<Node> findParent(Node n) {
        if (n.getComponent().getModuleKey() != null) {
            return this.findParentOfSourceFile(n);
        }
        return this.findParentOfModule(n);
    }

    private Optional<Node> findParentOfSourceFile(Node n) {
        return Optional.fromNullable((Object)this.getNodeByComponentKey(n.getComponent().getModuleKey()));
    }

    private Optional<Node> findParentOfModule(Node n) {
        String componentKey = n.getComponent().getKey();
        int moduleSeparatorPos = componentKey.lastIndexOf(58);
        if (moduleSeparatorPos < 0) {
            return Optional.absent();
        }
        String parentKeyTemplate = componentKey.substring(0, moduleSeparatorPos);
        Node parent = this.getNodeByComponentKey(parentKeyTemplate);
        if (parent != null) {
            return Optional.of((Object)parent);
        }
        int dotPosition = parentKeyTemplate.length();
        while (parent == null) {
            if ((dotPosition = parentKeyTemplate.lastIndexOf(46, dotPosition - 1)) < 0) {
                return Optional.absent();
            }
            String parentKey = parentKeyTemplate.substring(0, dotPosition) + ":" + parentKeyTemplate.substring(dotPosition + 1);
            parent = this.getNodeByComponentKey(parentKey);
        }
        return Optional.of((Object)parent);
    }

    private Node getNodeByComponentKey(String componentKey) {
        return this.nodes.get(componentKey);
    }

    private static class Node {
        private static final String GERRIT_FILE_DELIMITER = "/";
        private final Component component;
        private Node parent;

        public Node(Component c) {
            Preconditions.checkNotNull((Object)c);
            this.component = c;
        }

        private static void appendFileDelimiterIfNecessary(StringBuilder path) {
            if (path.length() > 0 && !Node.pathEndsWith(path, GERRIT_FILE_DELIMITER)) {
                path.append(GERRIT_FILE_DELIMITER);
            }
        }

        private static boolean pathEndsWith(StringBuilder path, String suffix) {
            int excess = path.length() - suffix.length();
            if (excess < 0) {
                return false;
            }
            for (int i = 0; i < suffix.length(); ++i) {
                if (path.charAt(excess + i) == suffix.charAt(i)) continue;
                return false;
            }
            return true;
        }

        public String buildPrefixedPath(String prefix) {
            StringBuilder path = new StringBuilder(prefix);
            this.buildPath(path);
            return path.toString();
        }

        private void buildPath(StringBuilder path) {
            String thisPath;
            if (this.isParentFound()) {
                this.getParent().buildPath(path);
            }
            if (!Strings.isNullOrEmpty((String)(thisPath = this.component.getPath()))) {
                Node.appendFileDelimiterIfNecessary(path);
                path.append(thisPath);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Optional<Node> parent) {
            Preconditions.checkNotNull(parent);
            this.parent = (Node)parent.or((Object)this);
        }

        public boolean isParentConnected() {
            return this.parent != null;
        }

        public boolean isParentFound() {
            return this.parent != null && this.parent != this;
        }
    }
}

