/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import com.google.common.base.MoreObjects;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.sonar.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ScoreConfig
extends AbstractDescribableImpl<ScoreConfig> {
    private IssueFilterConfig issueFilterConfig = new IssueFilterConfig();
    @Nonnull
    private Integer noIssuesScore = DescriptorImpl.NO_ISSUES_SCORE;
    @Nonnull
    private Integer issuesScore = DescriptorImpl.SOME_ISSUES_SCORE;
    @Nonnull
    private String category = "Code-Review";

    public ScoreConfig(IssueFilterConfig issueFilterConfig, String category, Integer noIssuesScore, Integer issuesScore) {
        this.setIssueFilterConfig(issueFilterConfig);
        this.setCategory(category);
        this.setNoIssuesScore(noIssuesScore);
        this.setIssuesScore(issuesScore);
    }

    @DataBoundConstructor
    public ScoreConfig() {
        this(new IssueFilterConfig(), "Code-Review", DescriptorImpl.NO_ISSUES_SCORE, DescriptorImpl.SOME_ISSUES_SCORE);
    }

    public IssueFilterConfig getIssueFilterConfig() {
        return this.issueFilterConfig;
    }

    @DataBoundSetter
    public void setIssueFilterConfig(IssueFilterConfig scoreIssueFilterConfig) {
        this.issueFilterConfig = (IssueFilterConfig)((Object)MoreObjects.firstNonNull((Object)((Object)scoreIssueFilterConfig), (Object)((Object)new IssueFilterConfig())));
    }

    @Nonnull
    public Integer getNoIssuesScore() {
        return this.noIssuesScore;
    }

    @DataBoundSetter
    public void setNoIssuesScore(Integer noIssuesScore) {
        this.noIssuesScore = (Integer)MoreObjects.firstNonNull((Object)noIssuesScore, (Object)DescriptorImpl.NO_ISSUES_SCORE);
    }

    @Nonnull
    public Integer getIssuesScore() {
        return this.issuesScore;
    }

    @DataBoundSetter
    public void setIssuesScore(Integer issuesScore) {
        this.issuesScore = (Integer)MoreObjects.firstNonNull((Object)issuesScore, (Object)DescriptorImpl.SOME_ISSUES_SCORE);
    }

    @Nonnull
    public String getCategory() {
        return this.category;
    }

    @DataBoundSetter
    public void setCategory(String category) {
        this.category = (String)MoreObjects.firstNonNull((Object)Util.fixEmptyAndTrim((String)category), (Object)"Code-Review");
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ScoreConfig> {
        public static final String CATEGORY = "Code-Review";
        public static final Integer NO_ISSUES_SCORE = SonarToGerritPublisher.DescriptorImpl.NO_ISSUES_SCORE;
        public static final Integer SOME_ISSUES_SCORE = SonarToGerritPublisher.DescriptorImpl.SOME_ISSUES_SCORE;

        public FormValidation doCheckNoIssuesScore(@QueryParameter String value) {
            return this.checkScore(value);
        }

        public FormValidation doCheckIssuesScore(@QueryParameter String value) {
            return this.checkScore(value);
        }

        private FormValidation checkScore(@QueryParameter String value) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.review.score.not.numeric"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCategory(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public String getDisplayName() {
            return "ScoreConfig";
        }
    }
}

