/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.ready.jenkins;

import com.smartbear.ready.jenkins.AuthMethod;
import com.smartbear.ready.jenkins.JUnitReportPublisher;
import com.smartbear.ready.jenkins.ParameterContainer;
import com.smartbear.ready.jenkins.PrintableReportPublisher;
import com.smartbear.ready.jenkins.ProcessRunner;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JenkinsSoapUIProTestRunner
extends Builder
implements SimpleBuildStep {
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private static final String SLM_LICENCE_ACCESS_KEY = "Access Key";
    private static final String API_HOST = "API Host";
    private static final String API_PORT = "API Port";
    private static final String API_KEY = "API KEY";
    private static final String CLIENT_ID = "Client Id";
    private static final String CLIENT_SECRET = "Client Secret";
    private static final String CLIENT_CREDENTIALS = "Client Credentials";
    private static final String ERROR_INFO = "Please, enter valid SLM %s for %s authentication method";
    private static final String NOT_EMPTY_VALUE_ERROR_INFO = "Field '%s' must be empty for %s authentication method";
    private static final String API_KEY_WARNING_MESSAGE = "Required when using license from SLM Onpremise License Server. Please enter valid %s for %s Authentication Method";
    private final String pathToTestrunner;
    private final String pathToProjectFile;
    private final Secret projectPassword;
    private final Secret slmLicenceAccessKey;
    private final Secret slmLicenseClientSecret;
    private String testSuite;
    private String testCase;
    private String testSuiteTags;
    private String testCaseTags;
    private String environment;
    private String authMethod;
    private String slmLicenceApiHost;
    private String slmLicenceApiPort;
    private String slmLicenseClientId;

    @DataBoundConstructor
    public JenkinsSoapUIProTestRunner(String pathToTestrunner, String pathToProjectFile, String projectPassword, String slmLicenceAccessKey, String slmLicenseClientSecret) {
        this.pathToTestrunner = pathToTestrunner;
        this.pathToProjectFile = pathToProjectFile;
        this.projectPassword = this.buildSecret(projectPassword);
        this.slmLicenceAccessKey = this.buildSecret(slmLicenceAccessKey);
        this.slmLicenseClientSecret = this.buildSecret(slmLicenseClientSecret);
    }

    private Secret buildSecret(String value) {
        return StringUtils.isNotEmpty((String)value) && !"********".equals(value) ? Secret.fromString((String)value) : null;
    }

    public String getPathToTestrunner() {
        return this.pathToTestrunner;
    }

    public String getPathToProjectFile() {
        return this.pathToProjectFile;
    }

    public String getTestSuite() {
        return this.testSuite;
    }

    @DataBoundSetter
    public void setTestSuite(String testSuite) {
        this.testSuite = testSuite;
    }

    public String getTestCase() {
        return this.testCase;
    }

    @DataBoundSetter
    public void setTestCase(String testCase) {
        this.testCase = testCase;
    }

    public String getTestSuiteTags() {
        return this.testSuiteTags;
    }

    @DataBoundSetter
    public void setTestSuiteTags(String tags) {
        this.testSuiteTags = tags;
    }

    public String getTestCaseTags() {
        return this.testCaseTags;
    }

    @DataBoundSetter
    public void setTestCaseTags(String tags) {
        this.testCaseTags = tags;
    }

    public Secret getProjectPassword() {
        return this.projectPassword;
    }

    public String getEnvironment() {
        return this.environment;
    }

    @DataBoundSetter
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Secret getSlmLicenceAccessKey() {
        return this.slmLicenceAccessKey;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    @DataBoundSetter
    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getSlmLicenceApiHost() {
        return this.slmLicenceApiHost;
    }

    @DataBoundSetter
    public void setSlmLicenceApiHost(String slmLicenceApiHost) {
        this.slmLicenceApiHost = slmLicenceApiHost;
    }

    public String getSlmLicenceApiPort() {
        return this.slmLicenceApiPort;
    }

    @DataBoundSetter
    public void setSlmLicenceApiPort(String slmLicenceApiPort) {
        this.slmLicenceApiPort = slmLicenceApiPort;
    }

    public String getSlmLicenseClientId() {
        return this.slmLicenseClientId;
    }

    @DataBoundSetter
    public void setSlmLicenseClientId(String slmLicenseClientId) {
        this.slmLicenseClientId = slmLicenseClientId;
    }

    public Secret getSlmLicenseClientSecret() {
        return this.slmLicenseClientSecret;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Proc process = null;
        ProcessRunner processRunner = new ProcessRunner();
        PrintStream out = listener.getLogger();
        try {
            boolean published;
            process = processRunner.run(new ParameterContainer.Builder().withPathToTestrunner(this.pathToTestrunner).withPathToProjectFile(this.pathToProjectFile).withTestSuite(this.testSuite).withTestCase(this.testCase).withTestSuiteTags(this.testSuiteTags).withTestCaseTags(this.testCaseTags).withProjectPassword(Secret.toString((Secret)this.getProjectPassword())).withEnvironment(this.environment).withAuthMethod(this.authMethod).withSlmLicenceApiHost(this.slmLicenceApiHost).withSlmLicenceApiPort(this.slmLicenceApiPort).withSlmLicenceAccessKey(Secret.toString((Secret)this.slmLicenceAccessKey)).withWorkspace(workspace).withSlmLicenseClientId(this.slmLicenseClientId).withSlmLicenseClientSecret(Secret.toString((Secret)this.slmLicenseClientSecret)).build(), run, launcher, listener);
            if (process == null) {
                throw new AbortException("Could not start ReadyAPI functional testing.");
            }
            if (process.join() != 0) {
                run.setResult(Result.FAILURE);
            }
            if (processRunner.isReportCreated() && !(published = new JUnitReportPublisher().publish(run, listener, launcher, processRunner.getReportsFolderPath()))) {
                out.println("JUnit-style report was not published!");
            }
            if (processRunner.isPrintableReportCreated()) {
                File printableReportFileOnMaster;
                String printableReportName = processRunner.getPrintableReportName();
                FilePath printableReportFileOnSlave = new FilePath(launcher.getChannel(), processRunner.getReportsFolderPath() + processRunner.getPrintableReportPath() + printableReportName);
                if (this.copyReportToBuildDir(printableReportFileOnSlave, new FilePath(printableReportFileOnMaster = new File(run.getRootDir().getAbsolutePath() + File.separator + printableReportName)), listener)) {
                    boolean printableReportPublished = new PrintableReportPublisher().publish(run, printableReportFileOnMaster, listener);
                    if (printableReportPublished) {
                        this.addPrintableReportLinkToConsoleOutput(out, run, printableReportName);
                    } else {
                        out.println("Printable report was not published!");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
            throw new AbortException("Could not start ReadyAPI functional testing.");
        }
        finally {
            if (process != null) {
                process.kill();
            }
        }
    }

    private boolean copyReportToBuildDir(FilePath fromFile, FilePath toFile, TaskListener listener) {
        try {
            if (fromFile.exists()) {
                toFile.copyFrom(fromFile);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
        }
        return false;
    }

    private void addPrintableReportLinkToConsoleOutput(PrintStream out, Run<?, ?> run, String printableReportName) {
        String printableReportLink = "/" + run.getUrl() + "soapui-pro-functional-testing" + "/dynamic/" + printableReportName;
        out.println(ModelHyperlinkNote.encodeTo((String)printableReportLink, (String)"Click here to view detailed report"));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"SoapUIPro"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public ListBoxModel doFillAuthMethodItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(AuthMethod.API_KEY.getDisplayName());
            items.add(AuthMethod.ACCESS_FOR_EVERYONE.getDisplayName());
            items.add(AuthMethod.CLIENT_CREDENTIALS.getDisplayName());
            return items;
        }

        public FormValidation doCheckPathToTestrunner(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please, set path to testrunner");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPathToProjectFile(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please, set path to the ReadyAPI project");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestSuite(@QueryParameter String value, @QueryParameter String testCase) {
            if (value.length() == 0 && testCase.length() != 0) {
                return FormValidation.error((String)"Please, enter a test suite for the specified test case");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthMethod(@QueryParameter String value, @QueryParameter String slmLicenceApiHost) {
            return FormValidation.ok();
        }

        public FormValidation doCheckSlmLicenceApiHost(@QueryParameter String value, @QueryParameter String authMethod) {
            AuthMethod slmAuthMethod = AuthMethod.getValue(authMethod);
            if (StringUtils.isEmpty((String)value)) {
                switch (slmAuthMethod) {
                    case ACCESS_FOR_EVERYONE: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.ERROR_INFO, JenkinsSoapUIProTestRunner.API_HOST, AuthMethod.ACCESS_FOR_EVERYONE.getDisplayName()));
                    }
                    case CLIENT_CREDENTIALS: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.ERROR_INFO, JenkinsSoapUIProTestRunner.API_HOST, AuthMethod.CLIENT_CREDENTIALS.getDisplayName()));
                    }
                    case API_KEY: {
                        return FormValidation.warning((String)String.format(JenkinsSoapUIProTestRunner.API_KEY_WARNING_MESSAGE, JenkinsSoapUIProTestRunner.API_HOST, AuthMethod.API_KEY.getDisplayName()));
                    }
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSlmLicenceApiPort(@QueryParameter String value, @QueryParameter String authMethod) {
            AuthMethod slmAuthMethod = AuthMethod.getValue(authMethod);
            if (!this.isValidPort(value)) {
                switch (slmAuthMethod) {
                    case ACCESS_FOR_EVERYONE: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.ERROR_INFO, JenkinsSoapUIProTestRunner.API_PORT, AuthMethod.ACCESS_FOR_EVERYONE.getDisplayName()));
                    }
                    case CLIENT_CREDENTIALS: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.ERROR_INFO, JenkinsSoapUIProTestRunner.API_PORT, AuthMethod.CLIENT_CREDENTIALS.getDisplayName()));
                    }
                    case API_KEY: {
                        return FormValidation.warning((String)String.format(JenkinsSoapUIProTestRunner.API_KEY_WARNING_MESSAGE, JenkinsSoapUIProTestRunner.API_PORT, AuthMethod.API_KEY.getDisplayName()));
                    }
                }
            }
            return FormValidation.ok();
        }

        private boolean isValidPort(String port) {
            return StringUtils.isNotEmpty((String)port) && this.hasValidPortContent(port);
        }

        private boolean hasValidPortContent(String port) {
            try {
                int portNumber = Integer.parseInt(port);
                return portNumber > 0 && portNumber <= 65535;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public FormValidation doCheckSlmLicenceAccessKey(@QueryParameter String value, @QueryParameter String authMethod) {
            AuthMethod slmAuthMethod = AuthMethod.getValue(authMethod);
            if (StringUtils.isNotEmpty((String)value)) {
                switch (slmAuthMethod) {
                    case ACCESS_FOR_EVERYONE: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.NOT_EMPTY_VALUE_ERROR_INFO, JenkinsSoapUIProTestRunner.API_KEY, slmAuthMethod.getDisplayName()));
                    }
                    case CLIENT_CREDENTIALS: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.NOT_EMPTY_VALUE_ERROR_INFO, JenkinsSoapUIProTestRunner.API_KEY, slmAuthMethod.getDisplayName()));
                    }
                }
            }
            return this.validateEmptyValue(value, AuthMethod.API_KEY, authMethod, JenkinsSoapUIProTestRunner.CLIENT_ID);
        }

        public FormValidation doCheckSlmLicenseClientId(@QueryParameter String value, @QueryParameter String authMethod) {
            AuthMethod slmAuthMethod = AuthMethod.getValue(authMethod);
            if (StringUtils.isNotEmpty((String)value)) {
                switch (slmAuthMethod) {
                    case API_KEY: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.NOT_EMPTY_VALUE_ERROR_INFO, JenkinsSoapUIProTestRunner.CLIENT_ID, slmAuthMethod.getDisplayName()));
                    }
                    case ACCESS_FOR_EVERYONE: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.NOT_EMPTY_VALUE_ERROR_INFO, JenkinsSoapUIProTestRunner.CLIENT_ID, slmAuthMethod.getDisplayName()));
                    }
                }
            }
            return this.validateEmptyValue(value, AuthMethod.CLIENT_CREDENTIALS, authMethod, JenkinsSoapUIProTestRunner.CLIENT_ID);
        }

        public FormValidation doCheckSlmLicenseClientSecret(@QueryParameter String value, @QueryParameter String authMethod) {
            AuthMethod slmAuthMethod = AuthMethod.getValue(authMethod);
            if (StringUtils.isNotEmpty((String)value)) {
                switch (slmAuthMethod) {
                    case API_KEY: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.NOT_EMPTY_VALUE_ERROR_INFO, JenkinsSoapUIProTestRunner.CLIENT_SECRET, slmAuthMethod.getDisplayName()));
                    }
                    case ACCESS_FOR_EVERYONE: {
                        return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.NOT_EMPTY_VALUE_ERROR_INFO, JenkinsSoapUIProTestRunner.CLIENT_SECRET, slmAuthMethod.getDisplayName()));
                    }
                }
            }
            return this.validateEmptyValue(value, AuthMethod.CLIENT_CREDENTIALS, authMethod, JenkinsSoapUIProTestRunner.CLIENT_SECRET);
        }

        private FormValidation validateEmptyValue(String value, AuthMethod authMethod, String selectedAuthMethod, String fieldName) {
            AuthMethod slmAuthMethod = AuthMethod.getValue(selectedAuthMethod);
            if (StringUtils.isEmpty((String)value) && authMethod.equals((Object)slmAuthMethod)) {
                return FormValidation.error((String)String.format(JenkinsSoapUIProTestRunner.ERROR_INFO, fieldName, slmAuthMethod.getDisplayName()));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "ReadyAPI Test: Run Functional Test";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

