/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

public abstract class EnumeratingWhitelist
extends Whitelist {
    private final Predicate<Method> methodCache = EnumeratingWhitelist.cache(this::methodSignatures, MethodSignature::matches);
    private final Predicate<Constructor<?>> constructorCache = EnumeratingWhitelist.cache(this::newSignatures, NewSignature::matches);
    private final Predicate<Method> staticMethodCache = EnumeratingWhitelist.cache(this::staticMethodSignatures, MethodSignature::matches);
    private final Predicate<Field> fieldCache = EnumeratingWhitelist.cache(this::fieldSignatures, FieldSignature::matches);
    private final Predicate<Field> staticFieldCache = EnumeratingWhitelist.cache(this::staticFieldSignatures, FieldSignature::matches);

    protected abstract List<MethodSignature> methodSignatures();

    protected abstract List<NewSignature> newSignatures();

    protected abstract List<MethodSignature> staticMethodSignatures();

    protected abstract List<FieldSignature> fieldSignatures();

    protected abstract List<FieldSignature> staticFieldSignatures();

    private static <M extends AccessibleObject, S extends Signature> Predicate<M> cache(Supplier<List<S>> signatures, BiPredicate<S, M> matches) {
        LoadingCache cache = Caffeine.newBuilder().weakKeys().build(m -> {
            for (Signature s : (List)signatures.get()) {
                if (!matches.test(s, m)) continue;
                return true;
            }
            return false;
        });
        return m -> {
            if (((List)signatures.get()).isEmpty()) {
                return false;
            }
            return (Boolean)cache.get(m);
        };
    }

    @Override
    public final boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        return this.methodCache.test(method);
    }

    @Override
    public final boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
        return this.constructorCache.test(constructor);
    }

    @Override
    public final boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
        return this.staticMethodCache.test(method);
    }

    @Override
    public final boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
        return this.fieldCache.test(field);
    }

    @Override
    public final boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
        return this.permitsFieldGet(field, receiver);
    }

    @Override
    public final boolean permitsStaticFieldGet(@NonNull Field field) {
        return this.staticFieldCache.test(field);
    }

    @Override
    public final boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
        return this.permitsStaticFieldGet(field);
    }

    @NonNull
    public static String getName(@NonNull Class<?> c) {
        Class<?> e = c.getComponentType();
        if (e == null) {
            return c.getName();
        }
        return EnumeratingWhitelist.getName(e) + "[]";
    }

    @NonNull
    public static String getName(@CheckForNull Object o) {
        return o == null ? "null" : EnumeratingWhitelist.getName(o.getClass());
    }

    private static boolean is(String thisIdentifier, String identifier) {
        return thisIdentifier.equals("*") || identifier.equals(thisIdentifier);
    }

    static StringBuilder joinWithSpaces(StringBuilder b, String[] types) {
        for (String type : types) {
            b.append(' ').append(type);
        }
        return b;
    }

    static String[] argumentTypes(Class<?>[] argumentTypes) {
        String[] s = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            s[i] = EnumeratingWhitelist.getName(argumentTypes[i]);
        }
        return s;
    }

    static String canonicalFieldString(@NonNull Field field) {
        return EnumeratingWhitelist.getName(field.getDeclaringClass()) + " " + field.getName();
    }

    static String canonicalMethodString(@NonNull Method method) {
        return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(EnumeratingWhitelist.getName(method.getDeclaringClass())).append(' ').append(method.getName()), EnumeratingWhitelist.argumentTypes(method.getParameterTypes())).toString();
    }

    static String canonicalConstructorString(@NonNull Constructor cons) {
        return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(EnumeratingWhitelist.getName(cons.getDeclaringClass())), EnumeratingWhitelist.argumentTypes(cons.getParameterTypes())).toString();
    }

    static String canonicalMethodSig(@NonNull Method method) {
        return "method " + EnumeratingWhitelist.canonicalMethodString(method);
    }

    static String canonicalStaticMethodSig(@NonNull Method method) {
        return "staticMethod " + EnumeratingWhitelist.canonicalMethodString(method);
    }

    static String canonicalConstructorSig(@NonNull Constructor cons) {
        return "new " + EnumeratingWhitelist.canonicalConstructorString(cons);
    }

    static String canonicalFieldSig(@NonNull Field field) {
        return "field " + EnumeratingWhitelist.canonicalFieldString(field);
    }

    static String canonicalStaticFieldSig(@NonNull Field field) {
        return "staticField " + EnumeratingWhitelist.canonicalFieldString(field);
    }

    public static abstract class Signature
    implements Comparable<Signature> {
        public abstract String toString();

        abstract String signaturePart();

        @Override
        public int compareTo(Signature o) {
            int r = this.signaturePart().compareTo(o.signaturePart());
            return r != 0 ? r : this.toString().compareTo(o.toString());
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        abstract boolean exists() throws Exception;

        static Class<?> type(String name) throws Exception {
            if (name.endsWith("[]")) {
                return Array.newInstance(Signature.type(name.substring(0, name.length() - 2)), 0).getClass();
            }
            switch (name) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            return Class.forName(name);
        }

        final Class<?>[] types(String[] names) throws Exception {
            Class[] r = new Class[names.length];
            for (int i = 0; i < names.length; ++i) {
                r[i] = Signature.type(names[i]);
            }
            return r;
        }

        public boolean isWildcard() {
            return false;
        }
    }

    static class StaticFieldSignature
    extends FieldSignature {
        StaticFieldSignature(String type, String field) {
            super(type, field);
        }

        @Override
        public String toString() {
            return "staticField " + this.signaturePart();
        }

        @Override
        boolean exists() throws Exception {
            try {
                return Modifier.isStatic(StaticFieldSignature.type(this.type).getField(this.field).getModifiers());
            }
            catch (NoSuchFieldException x) {
                return false;
            }
        }
    }

    public static class FieldSignature
    extends Signature {
        final String type;
        final String field;

        public FieldSignature(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public FieldSignature(Class<?> type, String field) {
            this(EnumeratingWhitelist.getName(type), field);
        }

        boolean matches(Field f) {
            return EnumeratingWhitelist.is(this.field, f.getName()) && EnumeratingWhitelist.getName(f.getDeclaringClass()).equals(this.type);
        }

        @Override
        String signaturePart() {
            return this.type + " " + this.field;
        }

        @Override
        public String toString() {
            return "field " + this.signaturePart();
        }

        @Override
        boolean exists() throws Exception {
            try {
                return !Modifier.isStatic(FieldSignature.type(this.type).getField(this.field).getModifiers());
            }
            catch (NoSuchFieldException x) {
                return false;
            }
        }

        @Override
        public boolean isWildcard() {
            return "*".equals(this.field);
        }
    }

    public static final class NewSignature
    extends Signature {
        private final String type;
        private final String[] argumentTypes;

        public NewSignature(String type, String ... argumentTypes) {
            this.type = type;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public NewSignature(Class<?> type, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(type), EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        boolean matches(Constructor<?> c) {
            return EnumeratingWhitelist.getName(c.getDeclaringClass()).equals(this.type) && Arrays.equals(EnumeratingWhitelist.argumentTypes(c.getParameterTypes()), this.argumentTypes);
        }

        @Override
        String signaturePart() {
            return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(this.type), this.argumentTypes).toString();
        }

        @Override
        public String toString() {
            return "new " + this.signaturePart();
        }

        @Override
        boolean exists() throws Exception {
            try {
                NewSignature.type(this.type).getDeclaredConstructor(this.types(this.argumentTypes));
                return true;
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }
    }

    static class StaticMethodSignature
    extends MethodSignature {
        StaticMethodSignature(String receiverType, String method, String ... argumentTypes) {
            super(receiverType, method, argumentTypes);
        }

        @Override
        public String toString() {
            return "staticMethod " + this.signaturePart();
        }

        @Override
        boolean exists() throws Exception {
            try {
                return Modifier.isStatic(StaticMethodSignature.type(this.receiverType).getDeclaredMethod(this.method, this.types(this.argumentTypes)).getModifiers());
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }
    }

    public static class MethodSignature
    extends Signature {
        final String receiverType;
        final String method;
        final String[] argumentTypes;

        public MethodSignature(String receiverType, String method, String ... argumentTypes) {
            this.receiverType = receiverType;
            this.method = method;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public MethodSignature(Class<?> receiverType, String method, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(receiverType), method, EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        boolean matches(Method m) {
            return EnumeratingWhitelist.is(this.method, m.getName()) && EnumeratingWhitelist.getName(m.getDeclaringClass()).equals(this.receiverType) && Arrays.equals(EnumeratingWhitelist.argumentTypes(m.getParameterTypes()), this.argumentTypes);
        }

        @Override
        public String toString() {
            return "method " + this.signaturePart();
        }

        @Override
        String signaturePart() {
            return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(this.receiverType).append(' ').append(this.method), this.argumentTypes).toString();
        }

        @Override
        boolean exists() throws Exception {
            return this.exists(MethodSignature.type(this.receiverType), true);
        }

        private boolean exists(Class<?> c, boolean start) throws Exception {
            Class<?> s = c.getSuperclass();
            if (s != null && this.exists(s, false)) {
                return !start;
            }
            for (Class<?> i : c.getInterfaces()) {
                if (!this.exists(i, false)) continue;
                return !start;
            }
            try {
                return !Modifier.isStatic(c.getDeclaredMethod(this.method, this.types(this.argumentTypes)).getModifiers());
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }

        @Override
        public boolean isWildcard() {
            return "*".equals(this.method);
        }
    }
}

