/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.util.FormValidation;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class SamlFormValidation {
    private SamlFormValidation() {
    }

    public static FormValidation checkStringFormat(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.ok();
        }
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"The field should have a value different than spaces");
        }
        return FormValidation.ok();
    }

    public static FormValidation checkStringAttributeFormat(String value, String message, boolean warn) {
        if (warn && StringUtils.isEmpty((String)value)) {
            return FormValidation.warning((String)message);
        }
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"The field should have a value different than spaces");
        }
        return FormValidation.ok();
    }

    public static FormValidation checkEmailFormat(String value, String message) {
        try {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.warning((String)message);
            }
            InternetAddress ia = new InternetAddress(value);
            ia.validate();
        }
        catch (AddressException ae) {
            return FormValidation.error((String)message);
        }
        return FormValidation.ok();
    }

    public static FormValidation checkUrlFormat(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return FormValidation.ok();
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"The url is malformed.", (Object[])new Object[]{e});
        }
        return FormValidation.ok();
    }

    public static FormValidation checkIntegerFormat(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.ok();
        }
        long i = 0L;
        try {
            i = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.", (Object[])new Object[]{e});
        }
        if (i < 0L) {
            return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
        }
        if (i > Integer.MAX_VALUE) {
            return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
        }
        return FormValidation.ok();
    }
}

