/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3.callable;

import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.plugins.s3.ClientHelper;
import hudson.util.Secret;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import jenkins.security.Roles;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

abstract class S3Callable<T>
implements FilePath.FileCallable<T> {
    private static final long serialVersionUID = 1L;
    private final String accessKey;
    private final Secret secretKey;
    private final boolean useRole;
    private final String region;
    private final ProxyConfiguration proxy;
    private final String customEndpoint;
    private final boolean usePathStyle;
    private static final HashMap<String, S3TransferManager> transferManagers = new HashMap();

    S3Callable(String accessKey, Secret secretKey, boolean useRole, String region, ProxyConfiguration proxy, boolean usePathStyle) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.useRole = useRole;
        this.region = region;
        this.proxy = proxy;
        this.customEndpoint = ClientHelper.ENDPOINT;
        this.usePathStyle = usePathStyle;
    }

    protected synchronized S3TransferManager getTransferManager() {
        String uniqueKey = this.getUniqueKey();
        if (transferManagers.get(uniqueKey) == null) {
            try {
                S3AsyncClient client = ClientHelper.createAsyncClient(this.accessKey, Secret.toString((Secret)this.secretKey), this.useRole, this.region, this.proxy, StringUtils.isNotEmpty((String)this.customEndpoint) ? new URI(this.customEndpoint) : null, 0x1000000L, this.usePathStyle);
                transferManagers.put(uniqueKey, S3TransferManager.builder().s3Client(client).build());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return transferManagers.get(uniqueKey);
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        roleChecker.check((RoleSensitive)this, Roles.SLAVE);
    }

    private String getUniqueKey() {
        return this.region + "_" + String.valueOf(this.secretKey) + "_" + this.accessKey + "_" + this.useRole;
    }
}

