/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.s3.ClientHelper;
import hudson.plugins.s3.Entry;
import hudson.plugins.s3.FileHelper;
import hudson.plugins.s3.FingerprintRecord;
import hudson.plugins.s3.MetadataPair;
import hudson.plugins.s3.S3ArtifactsAction;
import hudson.plugins.s3.S3ArtifactsProjectAction;
import hudson.plugins.s3.S3Profile;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Fingerprinter;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;

public final class S3BucketPublisher
extends Recorder
implements SimpleBuildStep {
    private String profileName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private final List<Entry> entries;
    private boolean dontWaitForConcurrentBuildCompletion;
    private boolean dontSetBuildResultOnFailure;
    private transient Level consoleLogLevel;
    private String consoleLogLevelString;
    private Result pluginFailureResultConstraint;
    private List<MetadataPair> userMetadata;

    @DataBoundConstructor
    public S3BucketPublisher(String profileName, List<Entry> entries, List<MetadataPair> userMetadata, boolean dontWaitForConcurrentBuildCompletion, String consoleLogLevel, String pluginFailureResultConstraint, boolean dontSetBuildResultOnFailure) {
        S3Profile[] sites;
        if (profileName == null && (sites = DESCRIPTOR.getProfiles()).length > 0) {
            profileName = sites[0].getName();
        }
        if (entries == null || entries.isEmpty()) {
            throw new IllegalArgumentException("No files to upload specified.");
        }
        this.profileName = profileName;
        this.entries = entries;
        this.userMetadata = userMetadata;
        if (this.userMetadata == null) {
            this.userMetadata = new ArrayList<MetadataPair>();
        }
        this.dontWaitForConcurrentBuildCompletion = dontWaitForConcurrentBuildCompletion;
        this.dontSetBuildResultOnFailure = dontSetBuildResultOnFailure;
        this.consoleLogLevel = this.parseLevel(consoleLogLevel);
        this.consoleLogLevelString = this.consoleLogLevel.getName();
        this.pluginFailureResultConstraint = pluginFailureResultConstraint == null ? Result.FAILURE : Result.fromString((String)pluginFailureResultConstraint);
    }

    private Level parseLevel(String lvl) {
        if (lvl == null) {
            lvl = "";
        }
        switch (lvl) {
            case "WARNING": {
                return Level.WARNING;
            }
            case "SEVERE": {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    protected Object readResolve() {
        if (this.userMetadata == null) {
            this.userMetadata = new ArrayList<MetadataPair>();
        }
        if (this.pluginFailureResultConstraint == null) {
            this.pluginFailureResultConstraint = Result.FAILURE;
        }
        if (this.consoleLogLevel != null && this.consoleLogLevelString == null) {
            this.consoleLogLevelString = this.consoleLogLevel.getName();
        }
        if (this.consoleLogLevel == null && this.consoleLogLevelString != null) {
            this.consoleLogLevel = this.parseLevel(this.consoleLogLevelString);
        }
        if (this.consoleLogLevel == null) {
            this.consoleLogLevel = Level.INFO;
        }
        if (this.consoleLogLevelString == null) {
            this.consoleLogLevelString = this.consoleLogLevel.getName();
        }
        return this;
    }

    private Result constrainResult(Result r, @NonNull TaskListener listener) {
        PrintStream console = listener.getLogger();
        if (r.isWorseThan(Result.FAILURE)) {
            return r;
        }
        if (r.isWorseThan(this.pluginFailureResultConstraint)) {
            this.log(console, "Build result constrained by configuration to: " + String.valueOf(this.pluginFailureResultConstraint) + " from: " + String.valueOf(Result.UNSTABLE));
            return this.pluginFailureResultConstraint;
        }
        return r;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public List<MetadataPair> getUserMetadata() {
        return this.userMetadata;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getPluginFailureResultConstraint() {
        if (this.pluginFailureResultConstraint == null) {
            return Result.FAILURE.toString();
        }
        return this.pluginFailureResultConstraint.toString();
    }

    public boolean isDontWaitForConcurrentBuildCompletion() {
        return this.dontWaitForConcurrentBuildCompletion;
    }

    public boolean isDontSetBuildResultOnFailure() {
        return this.dontSetBuildResultOnFailure;
    }

    public String getConsoleLogLevel() {
        return this.consoleLogLevelString;
    }

    public S3Profile getProfile() {
        return S3BucketPublisher.getProfile(this.profileName);
    }

    public static S3Profile getProfile(String profileName) {
        S3Profile[] profiles = DESCRIPTOR.getProfiles();
        if (profileName == null && profiles.length > 0) {
            return profiles[0];
        }
        for (S3Profile profile : profiles) {
            if (!profile.getName().equals(profileName)) continue;
            return profile;
        }
        throw new IllegalArgumentException("Can't find profile: " + profileName);
    }

    @NonNull
    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return ImmutableList.of((Object)new S3ArtifactsProjectAction(project));
    }

    private void log(PrintStream logger, String message) {
        this.log(Level.INFO, logger, message);
    }

    private void log(Level level, PrintStream logger, String message) {
        if (level.intValue() >= this.consoleLogLevel.intValue()) {
            logger.println(StringUtils.defaultString((String)this.getDescriptor().getDisplayName()) + " " + message);
        }
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath ws, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        S3Profile profile;
        PrintStream console = listener.getLogger();
        if (Result.ABORTED.equals(run.getResult())) {
            this.log(Level.SEVERE, console, "Skipping publishing on S3 because build aborted");
            return;
        }
        if (run.isBuilding()) {
            this.log(console, "Build is still running");
        }
        if ((profile = this.getProfile()) == null) {
            this.log(Level.SEVERE, console, "No S3 profile is configured.");
            if (!this.isDontSetBuildResultOnFailure()) {
                run.setResult(this.constrainResult(Result.UNSTABLE, listener));
                return;
            }
            throw new AbortException("No S3 profile is configured.");
        }
        this.log(console, "Using S3 profile: " + profile.getName());
        try {
            EnvVars envVars = run.getEnvironment(listener);
            HashMap record = Maps.newHashMap();
            CopyOnWriteArrayList<FingerprintRecord> artifacts = new CopyOnWriteArrayList<FingerprintRecord>();
            for (Entry entry : this.entries) {
                if (entry.noUploadOnFailure && Result.FAILURE.equals(run.getResult())) {
                    this.log(Level.WARNING, console, "Skipping publishing on S3 because build failed");
                    continue;
                }
                String expanded = Util.replaceMacro((String)entry.sourceFile, (Map)envVars);
                String exclude = Util.replaceMacro((String)entry.excludedFile, (Map)envVars);
                if (expanded == null) {
                    throw new IOException();
                }
                String bucket = Util.replaceMacro((String)entry.bucket, (Map)envVars);
                String storageClass = Util.replaceMacro((String)entry.storageClass, (Map)envVars);
                String selRegion = entry.selectedRegion;
                ArrayList<FilePath> paths = new ArrayList<FilePath>();
                ArrayList<String> filenames = new ArrayList<String>();
                for (String startPath : expanded.split(",")) {
                    for (FilePath path : ws.list(startPath, exclude)) {
                        if (path.isDirectory()) {
                            throw new IOException(String.valueOf(path) + " is a directory");
                        }
                        paths.add(path);
                        int workspacePath = FileHelper.getSearchPathLength(ws.getRemote(), startPath.trim(), this.getProfile().isKeepStructure());
                        filenames.add(this.getFilename(path, entry.flatten, workspacePath));
                        this.log(console, "bucket=" + bucket + ", file=" + path.getName() + " region=" + selRegion + ", will be uploaded from slave=" + entry.uploadFromSlave + " managed=" + entry.managedArtifacts + " , server encryption " + entry.useServerSideEncryption);
                    }
                }
                if (paths.isEmpty()) {
                    this.printDiagnostics(ws, console, expanded);
                    continue;
                }
                Map<String, String> escapedMetadata = this.buildMetadata((Map<String, String>)envVars, entry);
                ArrayList records = Lists.newArrayList();
                List<FingerprintRecord> fingerprints = profile.upload(run, bucket, paths, filenames, escapedMetadata, storageClass, selRegion, entry.uploadFromSlave, entry.managedArtifacts, entry.useServerSideEncryption, entry.gzipFiles);
                for (FingerprintRecord fingerprintRecord : fingerprints) {
                    records.add(fingerprintRecord);
                    fingerprintRecord.setKeepForever(entry.keepForever);
                    fingerprintRecord.setShowDirectlyInBrowser(entry.showDirectlyInBrowser);
                }
                if (!entry.managedArtifacts) continue;
                artifacts.addAll(fingerprints);
                this.fillFingerprints(run, listener, record, fingerprints);
            }
            if (!artifacts.isEmpty()) {
                this.addS3ArtifactsAction(run, profile, artifacts);
                this.addFingerprintAction(run, record);
            }
        }
        catch (IOException e) {
            if (!this.isDontSetBuildResultOnFailure()) {
                e.printStackTrace(listener.error("Failed to upload files"));
                run.setResult(this.constrainResult(Result.UNSTABLE, listener));
            }
            throw new IOException("Failed to upload files", e);
        }
    }

    private void addS3ArtifactsAction(Run<?, ?> run, S3Profile profile, List<FingerprintRecord> artifacts) {
        S3ArtifactsAction existingAction = (S3ArtifactsAction)run.getAction(S3ArtifactsAction.class);
        if (existingAction != null) {
            existingAction.getArtifacts().addAll(artifacts);
        } else {
            run.addAction((Action)new S3ArtifactsAction(run, profile, artifacts));
        }
    }

    private void addFingerprintAction(Run<?, ?> run, Map<String, String> record) {
        Fingerprinter.FingerprintAction existingAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
        if (existingAction != null) {
            existingAction.add(record);
        } else {
            run.addAction((Action)new Fingerprinter.FingerprintAction(run, record));
        }
    }

    private void printDiagnostics(@NonNull FilePath ws, PrintStream console, String expanded) throws IOException {
        this.log(Level.WARNING, console, "No file(s) found: " + expanded);
        try {
            String error = ws.validateAntFileMask(expanded, 100);
            if (error != null) {
                this.log(Level.WARNING, console, error);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private void fillFingerprints(@NonNull Run<?, ?> run, @NonNull TaskListener listener, Map<String, String> record, List<FingerprintRecord> fingerprints) throws IOException {
        for (FingerprintRecord r : fingerprints) {
            Fingerprint fp = r.addRecord(run);
            if (fp == null) {
                listener.error("Fingerprinting failed for " + r.getName());
                continue;
            }
            fp.addFor(run);
            record.put(r.getName(), fp.getHashString());
        }
    }

    private Map<String, String> buildMetadata(Map<String, String> envVars, Entry entry) {
        HashMap<String, String> mergedMetadata = new HashMap<String, String>();
        if (this.userMetadata != null) {
            for (MetadataPair pair : this.userMetadata) {
                mergedMetadata.put(pair.key, pair.value);
            }
        }
        if (entry.userMetadata != null) {
            for (MetadataPair pair : entry.userMetadata) {
                mergedMetadata.put(pair.key, pair.value);
            }
        }
        HashMap<String, String> escapedMetadata = new HashMap<String, String>();
        for (Map.Entry mapEntry : mergedMetadata.entrySet()) {
            escapedMetadata.put(Util.replaceMacro((String)((String)mapEntry.getKey()), envVars), Util.replaceMacro((String)((String)mapEntry.getValue()), envVars));
        }
        return escapedMetadata;
    }

    private String getFilename(FilePath src, boolean flatten, int searchIndex) {
        String fileName;
        if (flatten) {
            fileName = src.getName();
        } else {
            String relativeFileName = src.getRemote();
            fileName = relativeFileName.substring(searchIndex);
        }
        return fileName;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return this.dontWaitForConcurrentBuildCompletion ? BuildStepMonitor.NONE : BuildStepMonitor.STEP;
    }

    @Symbol(value={"s3Upload"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final CopyOnWriteList<S3Profile> profiles = new CopyOnWriteList();
        static final Level[] consoleLogLevels = new Level[]{Level.INFO, Level.WARNING, Level.SEVERE};
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        private static final Result[] pluginFailureResultConstraints = new Result[]{Result.FAILURE, Result.UNSTABLE, Result.SUCCESS};
        @Restricted(value={DoNotUse.class})
        @Deprecated
        public transient List<Region> regions = Entry.regions;
        @Restricted(value={DoNotUse.class})
        @Deprecated
        public transient String[] storageClasses = Entry.storageClasses;

        public DescriptorImpl(Class<? extends Publisher> clazz) {
            super(clazz);
            this.load();
        }

        public DescriptorImpl() {
            this(S3BucketPublisher.class);
        }

        public String getDisplayName() {
            return "Publish artifacts to S3 Bucket";
        }

        public String getHelpFile() {
            return "/plugin/s3/help.html";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            JSONArray array = json.optJSONArray("profile");
            if (array != null) {
                this.profiles.replaceBy((Collection)req.bindJSONToList(S3Profile.class, (Object)array));
            } else {
                this.profiles.replaceBy((Object[])new S3Profile[]{(S3Profile)req.bindJSON(S3Profile.class, json.getJSONObject("profile"))});
            }
            this.save();
            return true;
        }

        public ListBoxModel doFillProfileNameItems(@AncestorInPath Item item) {
            ListBoxModel model = new ListBoxModel();
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return model;
            }
            if (item == null && !Jenkins.get().hasPermission(Item.CREATE)) {
                return model;
            }
            for (S3Profile profile : this.profiles) {
                model.add(profile.getName(), profile.getName());
            }
            return model;
        }

        public ListBoxModel doFillConsoleLogLevelItems() {
            ListBoxModel model = new ListBoxModel();
            for (Level l : consoleLogLevels) {
                model.add(l.getName(), l.getLocalizedName());
            }
            return model;
        }

        public ListBoxModel doFillPluginFailureResultConstraintItems() {
            ListBoxModel model = new ListBoxModel();
            for (Result r : pluginFailureResultConstraints) {
                model.add(r.toString(), r.toString());
            }
            return model;
        }

        public void replaceProfiles(List<S3Profile> profiles) {
            this.profiles.replaceBy(profiles);
            this.save();
        }

        public Level[] getConsoleLogLevels() {
            return (Level[])consoleLogLevels.clone();
        }

        public S3Profile[] getProfiles() {
            Object[] profileArray = new S3Profile[this.profiles.size()];
            return (S3Profile[])this.profiles.toArray(profileArray);
        }

        public Result[] getPluginFailureResultConstraints() {
            return (Result[])pluginFailureResultConstraints.clone();
        }

        @RequirePOST
        public FormValidation doLoginCheck(@QueryParameter String name, @QueryParameter String accessKey, @QueryParameter Secret secretKey, @QueryParameter boolean useRole, @QueryParameter boolean usePathStyle) {
            boolean couldBeValidated;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String checkedName = Util.fixNull((String)name);
            String checkedAccessKey = Util.fixNull((String)accessKey);
            String checkedSecretKey = secretKey != null ? secretKey.getPlainText() : "";
            boolean bl = couldBeValidated = !checkedName.isEmpty() && !checkedAccessKey.isEmpty() && !checkedSecretKey.isEmpty();
            if (!couldBeValidated) {
                if (checkedName.isEmpty()) {
                    return FormValidation.ok((String)"Please, enter name");
                }
                if (useRole) {
                    return FormValidation.ok();
                }
                if (checkedAccessKey.isEmpty()) {
                    return FormValidation.ok((String)"Please, enter accessKey");
                }
                if (checkedSecretKey.isEmpty()) {
                    return FormValidation.ok((String)"Please, enter secretKey");
                }
            }
            String defaultRegion = ClientHelper.DEFAULT_AMAZON_S3_REGION_NAME;
            try (S3Client client = ClientHelper.createClient(checkedAccessKey, checkedSecretKey, useRole, defaultRegion, Jenkins.get().getProxy(), usePathStyle);){
                client.listBuckets();
            }
            catch (SdkException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                return FormValidation.error((String)("Can't connect to S3 service: " + e.getMessage()));
            }
            return FormValidation.ok((String)"Check passed!");
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }

    @Extension
    public static final class S3DeletedJobListener
    extends RunListener<Run> {
        public void onDeleted(Run run) {
            S3ArtifactsAction artifacts = (S3ArtifactsAction)run.getAction(S3ArtifactsAction.class);
            if (artifacts != null) {
                S3Profile profile = S3BucketPublisher.getProfile(artifacts.getProfile());
                for (FingerprintRecord record : artifacts.getArtifacts()) {
                    if (record.isKeepForever()) continue;
                    profile.delete(run, record);
                }
            }
        }
    }

    @Extension
    public static final class S3DeletedItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            if (item instanceof Job) {
                Job job = (Job)item;
                this.handleJobDeletion(job);
            } else if (item instanceof ItemGroup) {
                ItemGroup itemGroup = (ItemGroup)item;
                this.handleItemGroupDeletion(itemGroup);
            }
        }

        private void handleJobDeletion(Job<?, ?> job) {
            for (Run run : job.getBuilds()) {
                S3Profile profile;
                S3ArtifactsAction artifacts = (S3ArtifactsAction)run.getAction(S3ArtifactsAction.class);
                if (artifacts == null || !(profile = S3BucketPublisher.getProfile(artifacts.getProfile())).isDeleteArtifactsRecursively()) continue;
                for (FingerprintRecord record : artifacts.getArtifacts()) {
                    if (record.isKeepForever()) continue;
                    try {
                        profile.delete(run, record);
                    }
                    catch (Exception e) {
                        Logger.getLogger(S3DeletedItemListener.class.getName()).log(Level.WARNING, "Failed to delete S3 artifact: " + record.getName(), e);
                    }
                }
            }
        }

        private void handleItemGroupDeletion(ItemGroup<?> itemGroup) {
            for (Item item : itemGroup.getItems()) {
                if (item instanceof Job) {
                    Job job = (Job)item;
                    this.handleJobDeletion(job);
                    continue;
                }
                if (!(item instanceof ItemGroup)) continue;
                ItemGroup childItemGroup = (ItemGroup)item;
                this.handleItemGroupDeletion(childItemGroup);
            }
        }
    }
}

