/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import io.netty.handler.ssl.SslProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.util.JenkinsJVM;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class ClientHelper {
    public static final String DEFAULT_AMAZON_S3_REGION_NAME = System.getProperty("hudson.plugins.s3.DEFAULT_AMAZON_S3_REGION", Region.US_EAST_1.id());
    public static final String ENDPOINT = System.getProperty("hudson.plugins.s3.ENDPOINT", System.getenv("PLUGIN_S3_ENDPOINT"));
    public static final URI ENDPOINT_URI;

    @Deprecated
    public static S3AsyncClient createAsyncClient(String accessKey, String secretKey, boolean useRole, String region, @CheckForNull ProxyConfiguration proxy, @CheckForNull URI customEndpoint, Long thresholdInBytes) {
        return ClientHelper.createAsyncClient(accessKey, secretKey, useRole, region, proxy, customEndpoint, thresholdInBytes, false);
    }

    public static S3AsyncClient createAsyncClient(String accessKey, String secretKey, boolean useRole, String region, @CheckForNull ProxyConfiguration proxy, @CheckForNull URI customEndpoint, Long thresholdInBytes, boolean usePathStyle) {
        Region awsRegion = ClientHelper.getRegionFromString(region);
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        builder.region(awsRegion);
        if (!useRole) {
            builder = (S3AsyncClientBuilder)builder.credentialsProvider(() -> AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }
        if (customEndpoint != null) {
            builder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)builder.endpointOverride(customEndpoint)).forcePathStyle(Boolean.valueOf(usePathStyle));
            builder.httpClient(ClientHelper.getAsyncHttpClient(customEndpoint, proxy));
        } else if (ENDPOINT_URI != null) {
            builder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)builder.endpointOverride(ENDPOINT_URI)).forcePathStyle(Boolean.valueOf(usePathStyle));
            builder.httpClient(ClientHelper.getAsyncHttpClient(ENDPOINT_URI, proxy));
        } else {
            builder.httpClient(ClientHelper.getAsyncHttpClient(null, proxy));
        }
        if (thresholdInBytes != null) {
            builder.multipartConfiguration(mcb -> mcb.thresholdInBytes(thresholdInBytes));
        }
        return (S3AsyncClient)builder.build();
    }

    @Deprecated
    public static S3Client createClient(String accessKey, String secretKey, boolean useRole, String region, ProxyConfiguration proxy) {
        return ClientHelper.createClient(accessKey, secretKey, useRole, region, proxy, ENDPOINT_URI, false);
    }

    public static S3Client createClient(String accessKey, String secretKey, boolean useRole, String region, ProxyConfiguration proxy, boolean usePathStyle) {
        return ClientHelper.createClient(accessKey, secretKey, useRole, region, proxy, ENDPOINT_URI, usePathStyle);
    }

    @Deprecated
    public static S3Client createClient(String accessKey, String secretKey, boolean useRole, String region, ProxyConfiguration proxy, @CheckForNull URI customEndpoint) {
        return ClientHelper.createClient(accessKey, secretKey, useRole, region, proxy, customEndpoint, false);
    }

    public static S3Client createClient(String accessKey, String secretKey, boolean useRole, String region, ProxyConfiguration proxy, @CheckForNull URI customEndpoint, boolean usePathStyle) {
        Region awsRegion = ClientHelper.getRegionFromString(region);
        S3ClientBuilder builder = S3Client.builder();
        builder.region(awsRegion);
        if (!useRole) {
            builder = (S3ClientBuilder)builder.credentialsProvider(() -> AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }
        try {
            if (customEndpoint != null) {
                builder = (S3ClientBuilder)((S3ClientBuilder)builder.endpointOverride(customEndpoint)).forcePathStyle(Boolean.valueOf(usePathStyle));
                builder.httpClient(ClientHelper.getHttpClient(customEndpoint, proxy));
            } else if (ENDPOINT_URI != null) {
                builder = (S3ClientBuilder)((S3ClientBuilder)builder.endpointOverride(ENDPOINT_URI)).forcePathStyle(Boolean.valueOf(usePathStyle));
                builder.httpClient(ClientHelper.getHttpClient(ENDPOINT_URI, proxy));
            } else {
                builder.httpClient(ClientHelper.getHttpClient(null, proxy));
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't create proxy URI", e);
        }
        return (S3Client)builder.build();
    }

    @NonNull
    private static Region getRegionFromString(@CheckForNull String regionName) {
        Region region = null;
        region = regionName == null || regionName.isEmpty() ? Region.of((String)DEFAULT_AMAZON_S3_REGION_NAME) : Region.of((String)regionName);
        if (region == null) {
            throw new IllegalStateException("No AWS Region found for name '" + regionName + "' and default region '" + DEFAULT_AMAZON_S3_REGION_NAME + "'");
        }
        return region;
    }

    private static SdkHttpClient getHttpClient(URI serviceEndpoint, ProxyConfiguration proxy) throws URISyntaxException {
        ApacheHttpClient.Builder httpClient1 = ApacheHttpClient.builder();
        if (proxy == null && JenkinsJVM.isJenkinsJVM()) {
            proxy = Jenkins.get().getProxy();
        }
        if (ClientHelper.shouldUseProxy(proxy, serviceEndpoint)) {
            ProxyConfiguration.Builder proxyBuilder = software.amazon.awssdk.http.apache.ProxyConfiguration.builder().endpoint(new URI("http", null, proxy.getName(), proxy.getPort(), null, null, null));
            if (StringUtils.isNotEmpty((String)proxy.getUserName())) {
                proxyBuilder.username(proxy.getUserName()).password(proxy.getPassword());
            }
            httpClient1.proxyConfiguration((software.amazon.awssdk.http.apache.ProxyConfiguration)proxyBuilder.build());
        }
        return httpClient1.build();
    }

    private static SdkAsyncHttpClient getAsyncHttpClient(URI serviceEndpoint, ProxyConfiguration proxy) {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder().sslProvider(SslProvider.JDK);
        if (proxy == null && JenkinsJVM.isJenkinsJVM()) {
            proxy = Jenkins.get().getProxy();
        }
        if (ClientHelper.shouldUseProxy(proxy, serviceEndpoint)) {
            ProxyConfiguration.Builder proxyBuilder = software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().host(proxy.getName()).port(proxy.getPort());
            if (StringUtils.isNotEmpty((String)proxy.getUserName())) {
                proxyBuilder.username(proxy.getUserName()).password(proxy.getPassword());
            }
            builder.proxyConfiguration((software.amazon.awssdk.http.nio.netty.ProxyConfiguration)proxyBuilder.build());
        }
        return builder.build();
    }

    private static boolean shouldUseProxy(ProxyConfiguration proxy, @CheckForNull URI endpoint) {
        if (proxy == null) {
            return false;
        }
        if (endpoint == null) {
            return true;
        }
        String hostname = endpoint.getHost();
        if (hostname == null) {
            return true;
        }
        for (Pattern p : proxy.getNoProxyHostPatterns()) {
            if (!p.matcher(hostname).matches()) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            ENDPOINT_URI = StringUtils.isNotEmpty((String)ENDPOINT) ? new URI(ENDPOINT) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

