// CHECKSTYLE:OFF

package org.jenkins_ci.plugins.run_condition.contributed;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ShellCondition.Displayname}: {@code Execute Shell}.
     * 
     * @return
     *     {@code Execute Shell}
     */
    public static String ShellCondition_Displayname() {
        return holder.format("ShellCondition.Displayname");
    }

    /**
     * Key {@code ShellCondition.Displayname}: {@code Execute Shell}.
     * 
     * @return
     *     {@code Execute Shell}
     */
    public static Localizable _ShellCondition_Displayname() {
        return new Localizable(holder, "ShellCondition.Displayname");
    }

    /**
     * Key {@code BatchfileCondition.Displayname}: {@code Execute Windows
     * Batch commands}.
     * 
     * @return
     *     {@code Execute Windows Batch commands}
     */
    public static String BatchfileCondition_Displayname() {
        return holder.format("BatchfileCondition.Displayname");
    }

    /**
     * Key {@code BatchfileCondition.Displayname}: {@code Execute Windows
     * Batch commands}.
     * 
     * @return
     *     {@code Execute Windows Batch commands}
     */
    public static Localizable _BatchfileCondition_Displayname() {
        return new Localizable(holder, "BatchfileCondition.Displayname");
    }

    /**
     * Key {@code CommandInterpreterCondition.CommandFailed}: {@code command
     * execution failed}.
     * 
     * @return
     *     {@code command execution failed}
     */
    public static String CommandInterpreterCondition_CommandFailed() {
        return holder.format("CommandInterpreterCondition.CommandFailed");
    }

    /**
     * Key {@code CommandInterpreterCondition.CommandFailed}: {@code command
     * execution failed}.
     * 
     * @return
     *     {@code command execution failed}
     */
    public static Localizable _CommandInterpreterCondition_CommandFailed() {
        return new Localizable(holder, "CommandInterpreterCondition.CommandFailed");
    }

    /**
     * Key {@code CommandInterpreterCondition.UnableToProduceScript}: {@code
     * Unable to produce a script file}.
     * 
     * @return
     *     {@code Unable to produce a script file}
     */
    public static String CommandInterpreterCondition_UnableToProduceScript() {
        return holder.format("CommandInterpreterCondition.UnableToProduceScript");
    }

    /**
     * Key {@code CommandInterpreterCondition.UnableToProduceScript}: {@code
     * Unable to produce a script file}.
     * 
     * @return
     *     {@code Unable to produce a script file}
     */
    public static Localizable _CommandInterpreterCondition_UnableToProduceScript() {
        return new Localizable(holder, "CommandInterpreterCondition.UnableToProduceScript");
    }

    /**
     * Key {@code CommandInterpreterCondition.UnableToDelete}: {@code Unable
     * to delete script file {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to delete script file {0}}
     */
    public static String CommandInterpreterCondition_UnableToDelete(Object arg0) {
        return holder.format("CommandInterpreterCondition.UnableToDelete", arg0);
    }

    /**
     * Key {@code CommandInterpreterCondition.UnableToDelete}: {@code Unable
     * to delete script file {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to delete script file {0}}
     */
    public static Localizable _CommandInterpreterCondition_UnableToDelete(Object arg0) {
        return new Localizable(holder, "CommandInterpreterCondition.UnableToDelete", arg0);
    }

    /**
     * Key {@code CommandInterpreterCondition.UnableToCreateLauncher}: {@code
     * Unable to create Launcher in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to create Launcher in {0}}
     */
    public static String CommandInterpreterCondition_UnableToCreateLauncher(Object arg0) {
        return holder.format("CommandInterpreterCondition.UnableToCreateLauncher", arg0);
    }

    /**
     * Key {@code CommandInterpreterCondition.UnableToCreateLauncher}: {@code
     * Unable to create Launcher in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to create Launcher in {0}}
     */
    public static Localizable _CommandInterpreterCondition_UnableToCreateLauncher(Object arg0) {
        return new Localizable(holder, "CommandInterpreterCondition.UnableToCreateLauncher", arg0);
    }

}
