/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.rocketchatnotifier.RocketChatNotifier;

public class MessageBuilder {
    private static final Logger LOGGER = Logger.getLogger(MessageBuilder.class.getName());
    public static final String STARTING_STATUS_MESSAGE = "Starting...";
    public static final String END_STATUS_MESSAGE = "Finished";
    public static final String BACK_TO_NORMAL_STATUS_MESSAGE = "Back to normal";
    public static final String STILL_FAILING_STATUS_MESSAGE = "Still Failing";
    public static final String SUCCESS_STATUS_MESSAGE = "Success";
    public static final String FAILURE_STATUS_MESSAGE = "Failure";
    public static final String ABORTED_STATUS_MESSAGE = "Aborted";
    public static final String NOT_BUILT_STATUS_MESSAGE = "Not built";
    public static final String UNSTABLE_STATUS_MESSAGE = "Unstable";
    public static final String UNKNOWN_STATUS_MESSAGE = "Unknown";
    private StringBuffer message;
    private RocketChatNotifier notifier;
    private AbstractBuild build;
    private boolean finished = false;

    MessageBuilder(RocketChatNotifier notifier, AbstractBuild build, boolean finished) {
        this.notifier = notifier;
        this.message = new StringBuffer();
        this.build = build;
        this.finished = finished;
        this.startMessage();
    }

    MessageBuilder appendStatusMessage() {
        this.message.append(this.escape(this.getStatusMessage()));
        return this;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    String getStatusMessage() {
        AbstractBuild lastNonAbortedBuild;
        Result result = this.build.getResult();
        AbstractBuild previousBuild = this.build.getProject().getLastBuild().getPreviousBuild();
        Run previousSuccessfulBuild = this.build.getPreviousSuccessfulBuild();
        boolean buildHasSucceededBefore = previousSuccessfulBuild != null;
        for (lastNonAbortedBuild = previousBuild; lastNonAbortedBuild != null && lastNonAbortedBuild.getResult() == Result.ABORTED; lastNonAbortedBuild = lastNonAbortedBuild.getPreviousBuild()) {
        }
        Result previousResult = lastNonAbortedBuild == null ? Result.SUCCESS : lastNonAbortedBuild.getResult();
        if (result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && buildHasSucceededBefore) {
            return BACK_TO_NORMAL_STATUS_MESSAGE;
        }
        if (result == Result.FAILURE && previousResult == Result.FAILURE) {
            return STILL_FAILING_STATUS_MESSAGE;
        }
        if (result == Result.SUCCESS) {
            return SUCCESS_STATUS_MESSAGE;
        }
        if (result == Result.FAILURE) {
            return FAILURE_STATUS_MESSAGE;
        }
        if (result == Result.ABORTED) {
            return ABORTED_STATUS_MESSAGE;
        }
        if (result == Result.NOT_BUILT) {
            return NOT_BUILT_STATUS_MESSAGE;
        }
        if (result == Result.UNSTABLE) {
            return UNSTABLE_STATUS_MESSAGE;
        }
        if (this.build.isBuilding()) {
            if (this.finished) {
                return END_STATUS_MESSAGE;
            }
            return STARTING_STATUS_MESSAGE;
        }
        return UNKNOWN_STATUS_MESSAGE;
    }

    MessageBuilder append(String string) {
        this.message.append(this.escape(string));
        return this;
    }

    MessageBuilder append(Object string) {
        this.message.append(this.escape(string.toString()));
        return this;
    }

    private MessageBuilder startMessage() {
        this.message.append(this.escape(this.build.getProject().getFullDisplayName()));
        this.message.append(" - ");
        this.message.append(this.escape(this.build.getDisplayName()));
        this.message.append(" ");
        return this;
    }

    MessageBuilder appendOpenLink() {
        String url = this.notifier.getBuildServerUrl() + this.build.getUrl();
        this.message.append(" (<").append(url).append("|Open>)");
        return this;
    }

    MessageBuilder appendDuration() {
        this.message.append(" after ");
        String durationString = this.message.toString().contains(BACK_TO_NORMAL_STATUS_MESSAGE) ? this.createBackToNormalDurationString() : this.build.getDurationString().replace("and counting", "");
        this.message.append(durationString);
        return this;
    }

    MessageBuilder appendTestSummary() {
        AbstractTestResultAction action = (AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class);
        if (action != null) {
            int total = action.getTotalCount();
            int failed = action.getFailCount();
            int skipped = action.getSkipCount();
            this.message.append("\nTest Status:\n");
            this.message.append("\tPassed: " + (total - failed - skipped));
            this.message.append(", Failed: " + failed);
            this.message.append(", Skipped: " + skipped);
        } else {
            this.message.append("\nNo Tests found.");
        }
        return this;
    }

    MessageBuilder appendCustomMessage() {
        String customMessage = this.notifier.getCustomMessage();
        EnvVars envVars = new EnvVars();
        try {
            envVars = this.build.getEnvironment((TaskListener)new LogTaskListener(LOGGER, Level.INFO));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        this.message.append("\n");
        this.message.append(envVars.expand(customMessage));
        return this;
    }

    MessageBuilder appendLog() {
        List logs = null;
        try {
            logs = this.build.getLog(100);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        if (logs != null) {
            for (String log : logs) {
                this.message.append("\n");
                this.message.append(log);
            }
        }
        return this;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String createBackToNormalDurationString() {
        Run previousSuccessfulBuild = this.build.getPreviousSuccessfulBuild();
        long previousSuccessStartTime = previousSuccessfulBuild.getStartTimeInMillis();
        long previousSuccessDuration = previousSuccessfulBuild.getDuration();
        long previousSuccessEndTime = previousSuccessStartTime + previousSuccessDuration;
        long buildStartTime = this.build.getStartTimeInMillis();
        long buildDuration = this.build.getDuration();
        long buildEndTime = buildStartTime + buildDuration;
        long backToNormalDuration = buildEndTime - previousSuccessEndTime;
        return Util.getTimeSpanString((long)backToNormalDuration);
    }

    String escape(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    public String toString() {
        return this.message.toString();
    }
}

