/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.model;

import hudson.FilePath;
import hudson.model.Api;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.model.RobotCaseComparator;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResultStatistics;
import hudson.plugins.robot.model.RobotSuiteResult;
import hudson.plugins.robot.model.RobotTestObject;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RobotResult
extends RobotTestObject {
    private static final long serialVersionUID = 1L;
    private String timeStamp;
    private transient int passed;
    private transient int failed;
    private transient int skipped;
    private transient List<RobotResultStatistics> overallStats;
    private Map<String, RobotSuiteResult> suites;

    public RobotTestObject findObjectById(String id) {
        if (id.contains("/")) {
            String suiteName = id.substring(0, id.indexOf("/"));
            String childId = id.substring(id.indexOf("/") + 1);
            RobotSuiteResult suite = this.suites.get(suiteName);
            return suite.findObjectById(childId);
        }
        return null;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Exported
    public long getOverallPassed() {
        if (this.overallStats == null) {
            return this.passed;
        }
        if (this.overallStats.isEmpty()) {
            return 0L;
        }
        return this.overallStats.get(1).getPass();
    }

    @Exported
    public long getOverallFailed() {
        if (this.overallStats == null) {
            return this.failed;
        }
        if (this.overallStats.isEmpty()) {
            return 0L;
        }
        return this.overallStats.get(1).getFail();
    }

    @Exported
    public long getOverallSkipped() {
        if (this.overallStats == null) {
            return this.skipped;
        }
        if (this.overallStats.isEmpty()) {
            return 0L;
        }
        return this.overallStats.get(1).getSkip();
    }

    @Exported
    public long getOverallTotal() {
        if (this.overallStats == null) {
            return this.failed + this.passed + this.skipped;
        }
        if (this.overallStats.isEmpty()) {
            return 0L;
        }
        return this.overallStats.get(1).getTotal();
    }

    public List<RobotResultStatistics> getStatsByCategory() {
        return this.overallStats;
    }

    public void setStatsByCategory(List<RobotResultStatistics> statsByCategory) {
        this.overallStats = statsByCategory;
    }

    @Exported
    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public double getPassPercentage(boolean countSkipped) {
        long passed = this.getOverallPassed();
        long total = this.getOverallTotal();
        if (!countSkipped) {
            total -= this.getOverallSkipped();
        }
        if (total == 0L) {
            return 100.0;
        }
        double percentage = (double)passed / (double)total * 100.0;
        return RobotResult.roundToDecimals(percentage, 1);
    }

    @Exported
    public double getPassPercentage() {
        return this.getPassPercentage(false);
    }

    @Exported
    public double getSkipPercentage() {
        double percentage = (double)this.getSkipped() / (double)this.getOverallTotal() * 100.0;
        return RobotResult.roundToDecimals(percentage, 1);
    }

    private static double roundToDecimals(double value, int decimals) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(decimals, RoundingMode.DOWN);
        return bd.doubleValue();
    }

    public String getDisplayName() {
        return "Robot result";
    }

    public String getSearchUrl() {
        return "robot";
    }

    public RobotSuiteResult getSuite(String name) {
        return this.suites.get(name);
    }

    public void addSuite(RobotSuiteResult suite) {
        if (this.suites == null) {
            this.suites = new HashMap<String, RobotSuiteResult>();
        }
        int i = 1;
        String originalName = suite.getName();
        Object checkedSuiteName = originalName;
        while (this.suites.get(checkedSuiteName) != null) {
            checkedSuiteName = originalName + "_" + i;
            ++i;
        }
        suite.setDuplicateSafeName((String)checkedSuiteName);
        this.suites.put((String)checkedSuiteName, suite);
    }

    public Collection<RobotSuiteResult> getSuites() {
        if (this.suites != null) {
            return this.suites.values();
        }
        return Collections.emptyList();
    }

    @Exported
    public List<String> getExecutedSuites() {
        ArrayList<String> executedSuites = new ArrayList<String>();
        for (RobotSuiteResult robotSuiteResult : this.getAllSuites()) {
            Object name = robotSuiteResult.getName();
            for (RobotTestObject rto = robotSuiteResult.getParent(); rto != null && !rto.getName().isEmpty(); rto = rto.getParent()) {
                name = rto.getName() + "." + (String)name;
            }
            executedSuites.add((String)name);
        }
        return executedSuites;
    }

    public List<RobotSuiteResult> getAllSuites() {
        ArrayList<RobotSuiteResult> allSuites = new ArrayList<RobotSuiteResult>();
        for (RobotSuiteResult suite : this.getSuites()) {
            allSuites.add(suite);
            List<RobotSuiteResult> childSuites = suite.getAllChildSuites();
            allSuites.addAll(childSuites);
        }
        return allSuites;
    }

    public List<RobotCaseResult> getAllFailedCases() {
        ArrayList<RobotCaseResult> allFailedCases = new ArrayList<RobotCaseResult>();
        for (RobotSuiteResult suite : this.getSuites()) {
            List<RobotCaseResult> failedCases = suite.getAllFailedCases();
            allFailedCases.addAll(failedCases);
        }
        allFailedCases.sort(new RobotCaseComparator());
        return allFailedCases;
    }

    public List<RobotCaseResult> getAllPassedCases() {
        ArrayList<RobotCaseResult> allPassedCases = new ArrayList<RobotCaseResult>();
        for (RobotSuiteResult suite : this.getSuites()) {
            List<RobotCaseResult> passedCases = suite.getAllPassedCases();
            allPassedCases.addAll(passedCases);
        }
        allPassedCases.sort(new RobotCaseComparator());
        return allPassedCases;
    }

    public List<RobotCaseResult> getAllSkippedCases() {
        ArrayList<RobotCaseResult> allSkippedCases = new ArrayList<RobotCaseResult>();
        for (RobotSuiteResult suite : this.getSuites()) {
            List<RobotCaseResult> skippedCases = suite.getAllSkippedCases();
            allSkippedCases.addAll(skippedCases);
        }
        allSkippedCases.sort(new RobotCaseComparator());
        return allSkippedCases;
    }

    @Exported
    public List<String> getFailedCases() {
        ArrayList<String> failedCases = new ArrayList<String>();
        for (RobotCaseResult robotCaseResult : this.getAllFailedCases()) {
            String name = this.getCaseName(robotCaseResult);
            failedCases.add(name);
        }
        return failedCases;
    }

    @Exported
    public List<String> getPassedCases() {
        ArrayList<String> passedCases = new ArrayList<String>();
        for (RobotCaseResult robotCaseResult : this.getAllPassedCases()) {
            String name = this.getCaseName(robotCaseResult);
            passedCases.add(name);
        }
        return passedCases;
    }

    @Exported
    public List<String> getSkippedCases() {
        ArrayList<String> skippedCases = new ArrayList<String>();
        for (RobotCaseResult robotCaseResult : this.getAllSkippedCases()) {
            String name = this.getCaseName(robotCaseResult);
            skippedCases.add(name);
        }
        return skippedCases;
    }

    private String getCaseName(RobotCaseResult robotCaseResult) {
        Object name = robotCaseResult.getName();
        for (RobotTestObject rto = robotCaseResult.getParent(); rto != null && !rto.getName().isEmpty(); rto = rto.getParent()) {
            name = rto.getName() + "." + (String)name;
        }
        return name;
    }

    public void tally(RobotBuildAction robotBuildAction) {
        this.setParentAction(robotBuildAction);
        this.failed = 0;
        this.passed = 0;
        this.skipped = 0;
        this.duration = 0L;
        Collection<RobotSuiteResult> newSuites = this.getSuites();
        HashMap<String, RobotSuiteResult> newMap = new HashMap<String, RobotSuiteResult>(newSuites.size());
        for (RobotSuiteResult suite : newSuites) {
            suite.tally(robotBuildAction);
            this.failed += suite.getFailed();
            this.passed += suite.getPassed();
            this.skipped += suite.getSkipped();
            this.duration += suite.getDuration();
            newMap.put(suite.getDuplicateSafeName(), suite);
        }
        this.suites = newMap;
    }

    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        return this.suites.get(token);
    }

    public DirectoryBrowserSupport doReport(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, InterruptedException {
        RobotBuildAction parent = this.getParentAction();
        FilePath robotDir = null;
        if (parent != null) {
            robotDir = parent.getRobotDir();
        }
        if (robotDir != null && robotDir.exists() && StringUtils.isBlank((String)parent.getReportFileName())) {
            return new DirectoryBrowserSupport((ModelObject)this, robotDir, this.getDisplayName(), "folder.gif", true);
        }
        rsp.sendRedirect("notfound");
        return null;
    }

    @Override
    public RobotTestObject getParent() {
        return null;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public RobotResult getPreviousResult() {
        Run build = this.getOwner();
        if (build == null) {
            return null;
        }
        while ((build = build.getPreviousBuild()) != null) {
            RobotBuildAction parentAction = (RobotBuildAction)build.getAction(((Object)((Object)this.getParentAction())).getClass());
            if (parentAction == null) continue;
            return parentAction.getResult();
        }
        return null;
    }

    @Override
    public int getFailed() {
        return (int)this.getOverallFailed();
    }

    @Override
    public int getPassed() {
        return (int)this.getOverallPassed();
    }

    @Override
    public int getSkipped() {
        return (int)this.getOverallSkipped();
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public List<RobotCaseResult> getAllCases() {
        ArrayList<RobotCaseResult> allCases = new ArrayList<RobotCaseResult>();
        for (RobotSuiteResult suite : this.getSuites()) {
            List<RobotCaseResult> cases = suite.getAllCases();
            allCases.addAll(cases);
        }
        allCases.sort(new RobotCaseComparator());
        return allCases;
    }
}

